package cn.tworice.system.service.department;


import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.query.MPJLambdaWrapperX;
import cn.tworice.system.dao.department.UserDepartmentDao;
import cn.tworice.system.dao.department.po.UserDepartmentDO;
import cn.tworice.system.dao.user.po.UserDO;
import cn.tworice.system.dao.department.DepartmentDao;
import cn.tworice.system.dao.department.po.DepartmentDO;
import cn.tworice.system.dao.department.po.SystemDeployLogDO;
import cn.tworice.system.service.department.constand.DepartmentConst;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


/**
 * 部门管理服务
 */
@Service
public class DepartmentServiceImpl extends ServiceImpl<DepartmentDao,DepartmentDO> implements DepartmentService{

    @Resource
    private DepartmentDao departmentDao;

    @Resource
    private UserDepartmentDao userDepartmentDao;

    @Resource
    private SystemDeployLogService systemDeployLogService;

    /**
     * 添加人员到部门
     * @author 二饭
     */
    @Override
    public boolean addAdminToDepartment(String[] users, Integer departmentId) {
        // 判断该部门中有没有该人员
        Long i = userDepartmentDao.selectCount(new LambdaQueryWrapperX<UserDepartmentDO>()
                .eq(UserDepartmentDO::getDepartmentId, departmentId)
                .in(UserDepartmentDO::getUserId, Arrays.asList(users)
                )
        );
        if(i==0){
            // 如果没有
            this.addLog(users, departmentId, DepartmentConst.MOVE_IN);
            return userDepartmentDao.insertBatch(buildUserDepartmentList(users, departmentId));
        }
        return false;
    }

    /**
     * 从部门中移除人员
     * @author 二饭
     */
    @Override
    public void delAdminToDepartment(String[] adminIds, Integer departmentId) {
        userDepartmentDao.delete(new LambdaQueryWrapperX<UserDepartmentDO>()
                .in(UserDepartmentDO::getUserId, Arrays.asList(adminIds))
                .eq(UserDepartmentDO::getDepartmentId,departmentId)
        );
        this.addLog(adminIds, departmentId, DepartmentConst.REMOVE);
    }

    /**
     * 删除部门
     * 需要同时删除 部门表 和 部门资源表 所有相关内容
     * @author 二饭
     */
    @Override
    public boolean delDepartment(List<Integer> departmentIds) {
        // 同时删除部门相关的人员
        if(departmentDao.deleteBatchIds(departmentIds)>0){
            userDepartmentDao.delete(new LambdaQueryWrapperX<UserDepartmentDO>().in(UserDepartmentDO::getDepartmentId, departmentIds));
            return true;
        }
        return false;
    }

    /**
     *
     * @param userId 用户ID数组
     * @param departmentId 部门ID
     * @param state 调动状态 移入 移出
     * @author 二饭 [2023/4/12]
     **/
    private void addLog(String[] userId, Integer departmentId,String state) {
        List<SystemDeployLogDO> list = new ArrayList<>();
        for (String id : userId) {
            SystemDeployLogDO log = new SystemDeployLogDO();
            log.setUserId(id);
            log.setState(state);
            log.setDeployId(departmentId);
            list.add(log);
        }
        systemDeployLogService.saveBatch(list);
    }

    private List<UserDepartmentDO> buildUserDepartmentList(String[] users, Integer departmentId) {
        List<UserDepartmentDO> list = new ArrayList<>();
        Arrays.stream(users).forEach(item->{
            list.add(new UserDepartmentDO().setDepartmentId(departmentId).setUserId(item));
        });
        return list;
    }
}