package cn.tworice.system.controller.system;



import cn.tworice.auth.service.VerifyManger;
import cn.tworice.common.util.SystemInfoUtil;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.system.service.system.SystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;

/**
 * 系统管理模块 接口
 *
 * @author 二饭
 */
@RestController
@RequestMapping("admin/system")
@Slf4j
@CrossOrigin
@Api(tags = "系统工具")
public class SystemController {

    @Autowired
    private VerifyManger verifyManger;

    @Resource
    private SystemService systemService;

    @Value("${tworice.dev:false}")
    private Boolean devState;

    @GetMapping("online")
    public RequestResult online(){
        return RequestResult.success()
                .appendData("list", verifyManger.onlineMap());
    }

    /**
     * 使该Key失效
     * @param key Token
     */
    @DeleteMapping("offline")
    public RequestResult offline(String key){
        verifyManger.offline(key);
        return RequestResult.success();
    }

    /**
     * 获取系统信息
     * @author 二饭[tworice@sina.cn][2022/1/7 21:20]
     */
    @GetMapping("systemInfo")
    public RequestResult systemInfo(){
        SystemInfoUtil systemInfoUtil = new SystemInfoUtil();
        return RequestResult.success()
                .appendData("systemInfo", systemInfoUtil.getSystemInfo())
                .appendData("memoryInfo", systemInfoUtil.getMemoryInfo())
                .appendData("processInfo", systemInfoUtil.getProcessInfo())
                .appendData("cpuInfo", systemInfoUtil.getCpuInfo());
    }

    /**
     * 系统恢复
     * @return cn.tworice.common.vo.RequestResult
     * @author 二饭 [2023/9/19]
     **/
    @GetMapping("recovery")
    @ApiOperation("系统恢复")
    public RequestResult recovery() throws UnsupportedEncodingException {
        if(!devState){
            return RequestResult.error("系统当前不支持初始化");
        }
        systemService.recoveryBySQLResource();
        return RequestResult.success("系统已经初始化");
    }
}
