package cn.tworice.system.controller.feedback;

import cn.tworice.common.util.excel.ExcelUtil;
import cn.tworice.log.annotation.Log;
import cn.tworice.common.util.excel.InductsListener;
import cn.tworice.common.vo.*;
import cn.tworice.mybatis.vo.PageParam;
import com.alibaba.excel.EasyExcel;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import cn.tworice.system.service.feedback.SystemFeedbackTypeService;
import cn.tworice.system.dao.feedback.po.SystemFeedbackTypeDO;
import java.io.InputStream;

import io.swagger.annotations.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Resource;

@RestController
@RequestMapping("/client/systemFeedbackType")
@CrossOrigin
@Log(table = "system_feedback_type")
@Api(tags = "反馈类型")
public class SystemFeedbackTypeController {
    @Resource
    private SystemFeedbackTypeService service;

    @GetMapping("list")
    @ApiOperation("获取分页列表")
    public RequestResult list(PageParam pageParam, @ApiParam("查询条件") SystemFeedbackTypeDO entity) {
        return RequestResult.success().setData(service.getPage(pageParam, entity));
    }

    @PostMapping("add")
    @ApiOperation("更新数据")
    public RequestResult add(SystemFeedbackTypeDO entity) {
        service.set(entity);
        return RequestResult.success("更新数据成功")
                ;
    }

    @DeleteMapping("del")
    @ApiOperation("删除数据")
    public RequestResult del(@ApiParam("数据ID数组")
                             Integer[] ids) {
        service.del(ids);
        return RequestResult.success("成功删除数据")
                ;
    }

    @PostMapping("inducts")
    @ApiOperation("Excel表格批量上传数据")
    public RequestResult inducts(@ApiParam("Excel文件")
                                 MultipartFile file) {
        try {
            InputStream inputStream = file.getInputStream();
            EasyExcel.read(inputStream, SystemFeedbackTypeDO.class, new InductsListener(service)).sheet().doRead();
            return RequestResult.success("批量导入数据成功")
                    ;
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @GetMapping("template")
    @ApiOperation("导出Excel模板")
    public void template(HttpServletResponse response) throws IOException {
        ExcelUtil.exportExcelTemplate(response, SystemFeedbackTypeDO.class);
    }

    @GetMapping("info")
    @ApiOperation("获取数据")
    public RequestResult info(Integer id) {
        return RequestResult.success().appendData("info", service.info(id));
    }
}