package cn.tworice.system.controller.department;


import cn.tworice.common.util.excel.InductsListener;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.log.annotation.Log;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.system.dao.department.po.SystemDeployLogDO;
import cn.tworice.system.service.department.SystemDeployLogService;
import com.alibaba.excel.EasyExcel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;

@RestController
@RequestMapping("/client/systemDeployLog")
@CrossOrigin
@Log(table = "system_deploy_log")
@Api(tags = "人事调动记录")
public class SystemDeployLogController {
    @Resource
    private SystemDeployLogService service;

    @GetMapping("list")
    @ApiOperation("获取分页列表")
    public RequestResult list(PageParam pageParam, @ApiParam("查询条件") SystemDeployLogDO entity) {
        return RequestResult.success(201, "数据列表刷新成功")
                .setData(service.list(pageParam, entity));
    }

    @PostMapping("add")
    @ApiOperation("更新数据")
    public RequestResult add(SystemDeployLogDO entity) {
        service.set(entity);
        return RequestResult.success("更新数据成功")
                ;
    }

    @DeleteMapping("del")
    @ApiOperation("删除数据")
    public RequestResult del(@ApiParam("数据ID数组")
                             Integer[] ids) {
        service.del(ids);
        return RequestResult.success("成功删除数据")
                ;
    }

    @PostMapping("inducts")
    @ApiOperation("Excel表格批量上传数据")
    public RequestResult inducts(@ApiParam("Excel文件")
                                 MultipartFile file) {
        try {
            InputStream inputStream = file.getInputStream();
            EasyExcel.read(inputStream, SystemDeployLogDO.class, new InductsListener(service)).sheet().doRead();
            return RequestResult.success("批量导入数据成功")
                    ;
        } catch (Exception ex) {
            ex.printStackTrace();
            return RequestResult.error("批量导入数据失败")
                    ;
        }
    }

    /**
     * 导出模板     * @param response 结果     * @throws IOException 可能的IO异常
     */
    @GetMapping("template")
    @ApiOperation("导出Excel模板")
    public void template(HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel")
        ;
        response.setCharacterEncoding("utf-8")
        ;
        String fileName = URLEncoder.encode("模板", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx")
        ;
        EasyExcel.write(response.getOutputStream(), SystemDeployLogDO.class).sheet("模板")
                .doWrite(new ArrayList<>());
    }

    @GetMapping("info")
    @ApiOperation("获取数据")
    public RequestResult info(Integer id) {
        return RequestResult.success().appendData("info", service.info(id));
    }
}