package cn.tworice.netty.message;


import lombok.AllArgsConstructor;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

@Data
@AllArgsConstructor
public class Message implements Serializable {
    /**
     * 发送人用户标识
     **/
    private String uid;
    /**
     * 发送人所在组，用于握手时携带，为后续接收组消息时进行批量发送
     **/
    private String gid;
    /**
     * 接收客户端唯一标识
     * 根据消息类型确认：可以是用户标识、组标识
     **/
    private String to;
    /**
     * 发送时间
     **/
    private Date sendTime;
    /**
     * 内容
     **/
    private String content;
    /**
     * 消息类型
     **/
    private MessageType type;

    /**
     * 消息格式
     */
    private MessageFormat format;

    public enum MessageFormat {
        MEDIA, TEXT
    }

    public enum MessageType {
        TO_ALL, TO_ONE, TO_GROUP, LOGIN
    }
}
