package cn.tworice.netty.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Getter
@Setter
@Component
@ConfigurationProperties(prefix = "tworice.netty")
public class NettyProperties {
    private Integer port = 18080;
    /**
     * 处理连接建立和断开的线程数
     **/
    private Integer boss = 1;

    /**
     * 处理操作的线程数
     **/
    private Integer work = 3;
    /**
     * 等待队列的最大长度
     * 如果等待队列已满，新的连接请求将会被拒绝
     **/
    private Integer backlog = 128;

    /**
     * 在长时间没有数据交流的情况下，检测连接是否仍然保持活动状态
     **/
    private Boolean keepalive = true;

    private String path = "/websocket";

    /**
     * 每个聚合的消息的最大长度,65536表示64KB
     * 当消息长度超过了这个值，那么它将被分割成多个小的消息，每个小的消息的长度不超过64KB
     **/
    private Integer maxContentLength = 65536;
}
