/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.netty.session;

import cn.tworice.netty.session.Session;
import io.netty.channel.Channel;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class SessionManager {
    private final Map<String, Session> sessionMap = new ConcurrentHashMap<String, Session>();
    private final Map<String, DefaultChannelGroup> gidChannelGroup = new ConcurrentHashMap<String, DefaultChannelGroup>();
    private final Map<String, DefaultChannelGroup> uidChannelGroup = new ConcurrentHashMap<String, DefaultChannelGroup>();
    private final DefaultChannelGroup allChannelGroup = this.getDefaultChannelGroup();

    public void addChannel(String uid, String gid, Channel channel) {
        this.addSession(Session.buildSession(uid, gid, channel));
    }

    public Session addChannel(Channel channel) {
        return this.addSession(Session.buildSession(channel));
    }

    public void addChannel(String uid, Channel channel) {
        this.addSession(Session.buildSession(uid, null, channel));
    }

    public Session addSession(Session session) {
        this.addSession2Group(session);
        if (session.getGid() == null) {
            this.addSession2Uid(session);
        }
        this.sessionMap.put(session.getId(), session);
        this.allChannelGroup.add(session.getChannel());
        return session;
    }

    public Session removeChannel(Channel channel) {
        Session session = this.sessionMap.remove(channel.id().asLongText());
        channel.close();
        if (session.getGid() != null && this.gidChannelGroup.get(session.getGid()).isEmpty()) {
            this.gidChannelGroup.remove(session.getGid());
        }
        if (session.getUid() != null && this.uidChannelGroup.get(session.getUid()).isEmpty()) {
            this.uidChannelGroup.remove(session.getUid());
        }
        return session;
    }

    public void removeGidGroup(String gid) {
        for (Channel channel : this.gidChannelGroup.get(gid)) {
            channel.close();
            this.removeChannel(channel);
        }
    }

    public void removeUidGroup(String uid) {
        for (Channel channel : this.uidChannelGroup.get(uid)) {
            channel.close();
            this.removeChannel(channel);
        }
    }

    public DefaultChannelGroup getGidGroup(String gid) {
        return this.gidChannelGroup.get(gid);
    }

    public DefaultChannelGroup getUidGroup(String uid) {
        return this.uidChannelGroup.get(uid);
    }

    private DefaultChannelGroup getDefaultChannelGroup() {
        return new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    private void addSession2Group(Session session) {
        if (session.getGid() != null) {
            if (!this.gidChannelGroup.containsKey(session.getGid())) {
                this.gidChannelGroup.put(session.getGid(), this.getDefaultChannelGroup());
            }
            this.gidChannelGroup.get(session.getGid()).add(session.getChannel());
        }
    }

    private void addSession2Uid(Session session) {
        Optional.ofNullable(session.getUid()).ifPresent(uid -> {
            if (this.uidChannelGroup.containsKey(uid)) {
                if (!this.uidChannelGroup.get(uid).isEmpty()) {
                    this.uidChannelGroup.get(uid).close();
                }
            } else {
                this.uidChannelGroup.put((String)uid, this.getDefaultChannelGroup());
            }
            this.uidChannelGroup.get(uid).add(session.getChannel());
        });
    }

    public DefaultChannelGroup getAllChannelGroup() {
        return this.allChannelGroup;
    }
}

