/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.netty.message;

import cn.tworice.common.util.StringUtils;
import cn.tworice.netty.exception.NotExistException;
import cn.tworice.netty.message.Message;
import cn.tworice.netty.session.Session;
import cn.tworice.netty.session.SessionManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageManager {
    private static final Logger log = LoggerFactory.getLogger(MessageManager.class);
    @Resource
    private SessionManager sessionManager;
    private Consumer<? super Message> messageConsumer = this::sendMessage;
    private Consumer<? super Session> offLineConsumer = this::offLineMessage;
    private Consumer<? super Session> onLineConsumer = this::onLineMessage;
    private Function<? super Message, String> authFunction = Message::getUid;

    public MessageManager setReceiveConsumer(Consumer<Message> consumer) {
        this.messageConsumer = consumer;
        return this;
    }

    public MessageManager setOffLineConsumer(Consumer<? super Session> consumer) {
        this.offLineConsumer = consumer;
        return this;
    }

    public MessageManager setOnLineConsumer(Consumer<? super Session> consumer) {
        this.onLineConsumer = consumer;
        return this;
    }

    public MessageManager setAuthFunction(Function<? super Message, String> authFunction) {
        this.authFunction = authFunction;
        return this;
    }

    public void sendUid(String uid, String msg) {
        if (StringUtils.isEmpty((String)uid)) {
            throw new NotExistException("TO_ONE\u6a21\u5f0f\u4e0b\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.debug("\u53d1\u9001\u6d88\u606f\u7ed9\u7528\u6237:{}", (Object)uid);
        if (this.sessionManager.getUidGroup(uid).isEmpty()) {
            throw new NotExistException(uid + "\u4e0d\u5b58\u5728");
        }
        this.sessionManager.getUidGroup(uid).writeAndFlush((Object)new TextWebSocketFrame(msg));
    }

    public void sendUidIfExist(String uid, String msg) {
        if (this.sessionManager.getUidGroup(uid) != null) {
            this.sendUid(uid, msg);
        }
    }

    public void sendAll(String msg) {
        log.debug("\u53d1\u9001\u6d88\u606f\u7ed9\u6240\u6709\u4eba");
        this.sessionManager.getAllChannelGroup().writeAndFlush((Object)new TextWebSocketFrame(msg));
    }

    public void sendGid(String gid, String msg) {
        if (StringUtils.isEmpty((String)gid)) {
            throw new NotExistException("TO_GROUP\u6a21\u5f0f\u4e0b\u7ec4\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.debug("\u53d1\u9001\u6d88\u606f\u7ed9\u7ec4:{}", (Object)gid);
        Optional.ofNullable(this.sessionManager.getGidGroup(gid)).ifPresent(channels -> channels.writeAndFlush((Object)new TextWebSocketFrame(msg)));
    }

    public void sendGid(Message msg) {
        log.debug("\u53d1\u9001\u6d88\u606f\u7ed9\u7ec4:{}", (Object)msg.getTo());
        JSONObject message = new JSONObject();
        message.put("form", (Object)msg.getUid());
        message.put("message", (Object)msg.getContent());
        message.put("format", (Object)msg.getFormat());
        Optional.ofNullable(this.sessionManager.getGidGroup(msg.getTo())).ifPresent(channels -> channels.writeAndFlush((Object)new TextWebSocketFrame(message.toJSONString())));
    }

    public void sendMessage(Message message) {
        if (Message.MessageType.TO_ONE.equals((Object)message.getType())) {
            this.sendUid(message.getTo(), message.getContent());
        } else if (Message.MessageType.TO_ALL.equals((Object)message.getType())) {
            this.sendAll(message.getContent());
        } else if (Message.MessageType.TO_GROUP.equals((Object)message.getType())) {
            this.sendGid(message);
        }
    }

    public void receiveMessage(ChannelHandlerContext ctx, TextWebSocketFrame frame) {
        try {
            Optional.ofNullable(JSON.parseObject((String)frame.text(), Message.class)).ifPresent(message -> {
                if (Message.MessageType.LOGIN.equals((Object)message.getType())) {
                    String uid = this.authFunction.apply((Message)message);
                    if (!StringUtils.isEmpty((String)uid)) {
                        Session.set("uid", uid, ctx.channel());
                        Optional.ofNullable(message.getGid()).ifPresent(gid -> Session.set("gid", gid, ctx.channel()));
                        this.onLine(this.sessionManager.addChannel(ctx.channel()));
                    }
                } else if (!StringUtils.isEmpty((String)((String)Session.get("uid", ctx.channel())))) {
                    message.setUid((String)Session.get("uid", ctx.channel()));
                    this.messageConsumer.accept((Message)message);
                } else {
                    ctx.channel().close();
                }
            });
        }
        catch (JSONException exception) {
            throw new RuntimeException("\u6536\u5230\u7684\u6d88\u606f\u65e0\u6cd5\u683c\u5f0f\u5316");
        }
    }

    public void offLine(Session session) {
        this.offLineConsumer.accept(session);
    }

    public void onLine(Session session) {
        this.onLineConsumer.accept(session);
    }

    public void offLineMessage(Session session) {
        log.debug("\u5ba2\u6237\u7aef\u4e0b\u7ebf\uff1a{}", (Object)session.getChannel().id().asLongText());
    }

    public void onLineMessage(Session session) {
        log.debug("\u5ba2\u6237\u7aef\u4e0a\u7ebf\uff1a{}", (Object)session.getChannel().id().asLongText());
    }
}

