/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.netty.session;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import org.springframework.util.StringUtils;

public class Session {
    private String id;
    private String uid;
    private String gid;
    private Channel channel;
    private long lastCommunicateTimeStamp = 0L;

    public static Session buildSession(String uid, String gid, Channel channel) {
        Session session = new Session();
        session.setId(channel.id().asLongText());
        session.setChannel(channel);
        session.setUid(uid);
        session.setGid(gid);
        session.setLastCommunicateTimeStamp(System.currentTimeMillis());
        return session;
    }

    public static Session buildSession(Channel channel) {
        String gid;
        Session session = new Session();
        String uid = (String)Session.get("uid", channel);
        if (!StringUtils.isEmpty((Object)uid)) {
            session.setUid(uid);
        }
        if (!StringUtils.isEmpty((Object)(gid = (String)Session.get("gid", channel)))) {
            session.setGid(gid);
        }
        session.setId(channel.id().asLongText());
        session.setLastCommunicateTimeStamp(System.currentTimeMillis());
        session.setChannel(channel);
        return session;
    }

    public static <T> T get(String key, Channel channel) {
        AttributeKey attributeKey = AttributeKey.valueOf((String)key);
        return (T)channel.attr(attributeKey).get();
    }

    public static void set(String key, Object content, Channel channel) {
        if (StringUtils.isEmpty((Object)key) || StringUtils.isEmpty((Object)content) || !channel.isOpen()) {
            return;
        }
        AttributeKey attributeKey = AttributeKey.valueOf((String)key);
        channel.attr(attributeKey).setIfAbsent(content);
    }

    public String getId() {
        return this.id;
    }

    public String getUid() {
        return this.uid;
    }

    public String getGid() {
        return this.gid;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public long getLastCommunicateTimeStamp() {
        return this.lastCommunicateTimeStamp;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setGid(String gid) {
        this.gid = gid;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setLastCommunicateTimeStamp(long lastCommunicateTimeStamp) {
        this.lastCommunicateTimeStamp = lastCommunicateTimeStamp;
    }
}

