/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.netty.hanlder;

import cn.tworice.netty.message.MessageManager;
import cn.tworice.netty.session.Session;
import cn.tworice.netty.session.SessionManager;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class WebSocketHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHandler.class);
    @Resource
    private SessionManager sessionManager;
    @Resource
    private MessageManager messageManager;

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof PingWebSocketFrame) {
            this.pingWebSocketFrameHandler(ctx, (PingWebSocketFrame)frame);
        } else if (frame instanceof TextWebSocketFrame) {
            this.textWebSocketFrameHandler(ctx, (TextWebSocketFrame)frame);
        } else if (frame instanceof CloseWebSocketFrame) {
            this.closeWebSocketFrameHandler(ctx, (CloseWebSocketFrame)frame);
        }
    }

    private void fullHttpRequestHandler(ChannelHandlerContext ctx, FullHttpRequest request) {
        String uri = request.uri();
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        log.debug("\u5ba2\u6237\u7aef\u5c1d\u8bd5\u5efa\u7acb\u8fde\u63a5\uff1a{}", (Object)ctx.channel().id().asLongText());
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        Session session = this.sessionManager.removeChannel(ctx.channel());
        this.messageManager.offLine(session);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("Netty\u63a7\u5236\u5668\u5f02\u5e38{}", (Object)ctx.channel().id().asLongText(), (Object)cause);
    }

    private void closeWebSocketFrameHandler(ChannelHandlerContext ctx, CloseWebSocketFrame frame) {
        ctx.close();
        Session session = this.sessionManager.removeChannel(ctx.channel());
        this.messageManager.offLine(session);
    }

    private void textWebSocketFrameHandler(ChannelHandlerContext ctx, TextWebSocketFrame frame) {
        log.debug("\u6536\u5230\u6d88\u606f:{}", (Object)frame.text());
        this.messageManager.receiveMessage(ctx, frame);
    }

    private void pingWebSocketFrameHandler(ChannelHandlerContext ctx, PingWebSocketFrame frame) {
        ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
    }
}

