/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.netty.config;

import cn.tworice.netty.config.NettyProperties;
import cn.tworice.netty.config.WebSocketInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NettyConfig {
    private static final Logger log = LoggerFactory.getLogger(NettyConfig.class);
    @Resource
    private NettyProperties nettyProperties;
    @Resource
    private WebSocketInitializer webSocketInitializer;

    @Bean
    public EventLoopGroup bossGroup() {
        return new NioEventLoopGroup(this.nettyProperties.getBoss().intValue());
    }

    @Bean
    public EventLoopGroup workerGroup() {
        return new NioEventLoopGroup(this.nettyProperties.getWork().intValue());
    }

    @Bean
    public ServerBootstrap serverBootstrap() {
        log.info("\u542f\u52a8Netty\u670d\u52a1\u5728\u3010{}\u3011\u4e0a", (Object)this.nettyProperties.getPort());
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.bossGroup(), this.workerGroup()).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)this.webSocketInitializer).option(ChannelOption.SO_BACKLOG, (Object)this.nettyProperties.getBacklog())).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.nettyProperties.getKeepalive());
        return serverBootstrap;
    }

    @Bean
    public ChannelFuture startServer() {
        return this.serverBootstrap().bind(this.nettyProperties.getPort().intValue());
    }
}

