/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.monitor.controller;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.monitor.service.MonitorService;
import cn.tworice.monitor.service.RequestFlowService;
import cn.tworice.monitor.vo.RequestInfo;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"admin/monitor"})
@RestController
public class MonitorController {
    @Resource
    private MonitorService monitorService;
    @Resource
    private RequestFlowService requestFlowService;

    @GetMapping(value={"log"})
    public RequestResult log() {
        return RequestResult.success().appendData("monitor", this.monitorService.log());
    }

    @GetMapping(value={"operation"})
    public RequestResult operation() {
        return RequestResult.success().appendData("monitor", this.monitorService.operation());
    }

    @GetMapping(value={"flow"})
    public RequestResult flow() {
        ConcurrentLinkedQueue<RequestInfo> queue = this.requestFlowService.getQueue();
        HashMap<String, Integer> ip = new HashMap<String, Integer>();
        HashMap<String, Integer> time = new HashMap<String, Integer>();
        for (RequestInfo requestInfo : queue) {
            String ipAddr = requestInfo.getIpAddr();
            if (ip.containsKey(ipAddr)) {
                ip.put(ipAddr, (Integer)ip.get(ipAddr) + 1);
            } else {
                ip.put(ipAddr, 1);
            }
            String date = requestInfo.getDate();
            if (time.containsKey(date)) {
                time.put(date, (Integer)time.get(date) + 1);
                continue;
            }
            time.put(date, 1);
        }
        return RequestResult.success().appendData("ip", ip).appendData("time", time);
    }

    @GetMapping(value={"sql"})
    public RequestResult sql() {
        return RequestResult.success().appendData("sql", this.requestFlowService.getSqlMap());
    }
}

