package cn.tworice.monitor.service;

import cn.tworice.log.dao.po.OperationLogDO;
import cn.tworice.monitor.dao.MonitorDao;
import cn.tworice.monitor.vo.Entity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Iterator;
import java.util.List;

@Service
public class MonitorService {

    @Resource
    private MonitorDao monitorDao;


    public List<Entity> log() {
        return monitorDao.queryLog();
    }

    public List<OperationLogDO> operation() {
        List<OperationLogDO> adminLogs = monitorDao.queryOperation();
        Iterator<OperationLogDO> iterator = adminLogs.iterator();
        if (iterator.hasNext()) {
            OperationLogDO next = iterator.next();
            if (next.getActive().startsWith("【已恢复】")) {
                iterator.remove();
            }
        }
        return adminLogs;
    }
}
