package cn.tworice.monitor.controller;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.monitor.service.MonitorService;
import cn.tworice.monitor.service.RequestFlowService;
import cn.tworice.monitor.vo.RequestInfo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

@RequestMapping("admin/monitor")
@RestController
public class MonitorController {

    @Resource
    private MonitorService monitorService;

    @Resource
    private RequestFlowService requestFlowService;

    @GetMapping("log")
    public RequestResult log() {
        return RequestResult.success().appendData("monitor",monitorService.log());
    }

    @GetMapping("operation")
    public RequestResult operation(){
        return RequestResult.success().appendData("monitor", monitorService.operation());
    }

    @GetMapping("flow")
    public RequestResult flow(){
        ConcurrentLinkedQueue<RequestInfo> queue = requestFlowService.getQueue();
        Map<String, Integer> ip = new HashMap<>();
        Map<String, Integer> time = new HashMap<>();
        for (RequestInfo requestInfo : queue) {
            String ipAddr = requestInfo.getIpAddr();
            if(ip.containsKey(ipAddr)){
                ip.put(ipAddr, ip.get(ipAddr)+ 1);
            }else{
                ip.put(ipAddr, 1);
            }

            String date = requestInfo.getDate();
            if(time.containsKey(date)){
                time.put(date, time.get(date)+ 1);
            }else{
                time.put(date, 1);
            }
        }
        return RequestResult.success().appendData("ip", ip).appendData("time",time);
    }

    @GetMapping("sql")
    public RequestResult sql() {
        return RequestResult.success().appendData("sql", requestFlowService.getSqlMap());
    }

}
