/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.minio.controller;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.minio.config.MinioPropertiesConfig;
import cn.tworice.minio.service.MinioService;
import io.minio.messages.Bucket;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"Minio\u670d\u52a1"})
@RestController
@RequestMapping(value={"admin/minio"})
public class MinioController {
    private static final Logger log = LoggerFactory.getLogger(MinioController.class);
    @Autowired
    private MinioService minioUtil;
    @Autowired
    private MinioPropertiesConfig prop;

    @ApiOperation(value="\u67e5\u770b\u5b58\u50a8bucket\u662f\u5426\u5b58\u5728")
    @GetMapping(value={"/bucketExists"})
    public RequestResult bucketExists(@RequestParam(value="bucketName") String bucketName) {
        return RequestResult.success().appendData("bucketName", (Object)this.minioUtil.bucketExists(bucketName));
    }

    @ApiOperation(value="\u521b\u5efa\u5b58\u50a8bucket")
    @GetMapping(value={"/makeBucket"})
    public RequestResult makeBucket(String bucketName) {
        return RequestResult.success().appendData("bucketName", (Object)this.minioUtil.makeBucket(bucketName));
    }

    @ApiOperation(value="\u5220\u9664\u5b58\u50a8bucket")
    @GetMapping(value={"/removeBucket"})
    public RequestResult removeBucket(String bucketName) {
        return RequestResult.success().appendData("bucketName", (Object)this.minioUtil.removeBucket(bucketName));
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8bucket")
    @GetMapping(value={"/getAllBuckets"})
    public RequestResult getAllBuckets() {
        List<Bucket> allBuckets = this.minioUtil.getAllBuckets();
        return RequestResult.success().appendData("allBuckets", allBuckets);
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20\u8fd4\u56deurl")
    @PostMapping(value={"/upload"})
    public RequestResult upload(@RequestParam(value="file") MultipartFile file) {
        String objectName = this.minioUtil.upload(file);
        if (null != objectName) {
            objectName = "/" + this.prop.getBucketName() + "/" + objectName;
            return RequestResult.success().appendData("url", (Object)(this.prop.getEndpoint() + objectName));
        }
        return RequestResult.error();
    }

    @ApiOperation(value="\u56fe\u7247/\u89c6\u9891\u9884\u89c8")
    @GetMapping(value={"/preview"})
    public RequestResult preview(@RequestParam(value="fileName") String fileName) {
        return RequestResult.success().appendData("fileName", (Object)this.minioUtil.preview(fileName));
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/download"})
    public RequestResult download(@RequestParam(value="fileName") String fileName, HttpServletResponse res) {
        this.minioUtil.download(fileName, res);
        return RequestResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u6587\u4ef6", notes="\u6839\u636eurl\u5730\u5740\u5220\u9664\u6587\u4ef6")
    @PostMapping(value={"/delete"})
    public RequestResult remove(String url) {
        String objName = url.substring(url.lastIndexOf(this.prop.getBucketName() + "/") + this.prop.getBucketName().length() + 1);
        this.minioUtil.remove(objName);
        return RequestResult.success().appendData("objName", (Object)objName);
    }
}

