package cn.tworice.common.framework.mail.core;

import cn.tworice.common.framework.mail.bo.SendMailBO;
import cn.tworice.common.util.MathUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

@Component
@Slf4j
public class MailExecutor {

    @Value("${tworice.mail.header:二饭技术}")
    private String header;

    @Value("${spring.mail.username}")
    private String email;

    @Autowired
    private JavaMailSender mailSender;

    public String sendEmailCaptcha(int length, String email,String title) {
        String verCode = MathUtils.getRandomNumber(length);
        // 发送邮件
        SendMailBO sendMailDto = new SendMailBO();
        sendMailDto.setTo(email);
        sendMailDto.setContent("您的验证码:" + verCode);
        sendMailDto.setSubject(title);
        this.sendMail(sendMailDto);
        return verCode;
    }

    /**
     * 发送邮件
     * @param mailBO 邮件业务内容
     */
    public void sendMail(SendMailBO mailBO){
        try {
            this.mailSender.send(this.getMessage(mailBO));
            log.info("邮件已发送。");
        } catch (Exception e) {
            log.error("发送邮件时发生异常了！", e);
            throw new RuntimeException("无法发送邮件，请联系管理员");
        }
    }

    /**
     * 发送邮件
     * @param email 目标邮箱
     * @param subject 主题
     * @param content 邮件内容
     */
    public void sendMail(String email, String subject, String content) {
        SendMailBO sendMailDto = new SendMailBO();
        sendMailDto.setTo(email);
        sendMailDto.setContent(content);
        sendMailDto.setSubject(subject);
        this.sendMail(sendMailDto);
    }

    /**
     * 发送HTML邮件
     * @param email 目标邮箱
     * @param subject 主题
     * @param content 邮件内容
     */
    public void sendHtmlMail(String email, String subject, String content) {
        SendMailBO sendMailDto = new SendMailBO();
        sendMailDto.setTo(email);
        sendMailDto.setContent(content);
        sendMailDto.setSubject(subject);
        sendMailDto.setSimple(false);
        this.sendMail(sendMailDto);
    }


    /**
     * 构建邮件内容
     * @param mailBO 邮件信息
     * @return javax.mail.internet.MimeMessage
     * @author 二饭 [2023/9/15]
     **/
    private MimeMessage getMessage(SendMailBO mailBO) throws Exception {
        MimeMessage message = mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, !mailBO.getSimple());
        helper.setFrom(new InternetAddress(MimeUtility.encodeText(this.header) + "<" + this.email + ">").toString());
        helper.setTo(mailBO.getTo());
        helper.setSubject(mailBO.getSubject());
        helper.setText(mailBO.getContent(), !mailBO.getSimple());
        if(!mailBO.getAttachment().isEmpty()){
            mailBO.getAttachment().forEach(item->{
                try {
                    helper.addAttachment(item.getName(),item.getFile());
                } catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return message;
    }



}
