/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.common.framework.mail.core;

import cn.tworice.common.framework.mail.bo.SendMailBO;
import cn.tworice.common.util.MathUtils;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class MailExecutor {
    private static final Logger log = LoggerFactory.getLogger(MailExecutor.class);
    @Value(value="${tworice.mail.header:\u4e8c\u996d\u6280\u672f}")
    private String header;
    @Value(value="${spring.mail.username}")
    private String email;
    @Autowired
    private JavaMailSender mailSender;

    public String sendEmailCaptcha(int length, String email, String title) {
        String verCode = MathUtils.getRandomNumber((int)length);
        SendMailBO sendMailDto = new SendMailBO();
        sendMailDto.setTo(email);
        sendMailDto.setContent("\u60a8\u7684\u9a8c\u8bc1\u7801:" + verCode);
        sendMailDto.setSubject(title);
        this.sendMail(sendMailDto);
        return verCode;
    }

    public void sendMail(SendMailBO mailBO) {
        try {
            this.mailSender.send(this.getMessage(mailBO));
            log.info("\u90ae\u4ef6\u5df2\u53d1\u9001\u3002");
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\u4e86\uff01", (Throwable)e);
            throw new RuntimeException("\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    public void sendMail(String email, String subject, String content) {
        SendMailBO sendMailDto = new SendMailBO();
        sendMailDto.setTo(email);
        sendMailDto.setContent(content);
        sendMailDto.setSubject(subject);
        this.sendMail(sendMailDto);
    }

    public void sendHtmlMail(String email, String subject, String content) {
        SendMailBO sendMailDto = new SendMailBO();
        sendMailDto.setTo(email);
        sendMailDto.setContent(content);
        sendMailDto.setSubject(subject);
        sendMailDto.setSimple(false);
        this.sendMail(sendMailDto);
    }

    private MimeMessage getMessage(SendMailBO mailBO) throws Exception {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, mailBO.getSimple() == false);
        helper.setFrom(new InternetAddress(MimeUtility.encodeText((String)this.header) + "<" + this.email + ">").toString());
        helper.setTo(mailBO.getTo());
        helper.setSubject(mailBO.getSubject());
        helper.setText(mailBO.getContent(), mailBO.getSimple() == false);
        if (!mailBO.getAttachment().isEmpty()) {
            mailBO.getAttachment().forEach(item -> {
                try {
                    helper.addAttachment(item.getName(), item.getFile());
                }
                catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return message;
    }
}

