package cn.tworice.ip.util;


import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;

import javax.servlet.http.HttpServletRequest;

public class UAUtil {

    public static String getDevice(HttpServletRequest request) {
        return UAUtil.getDevice(request.getHeader("User-Agent"));
    }

    /**
     * 解析 用户代理(User-Agent)
     * @param userAgent 用户代理User-Agent ,UA
     * @return "设备类型:%s,操作系统:%s,浏览器:%s,浏览器版本:%s,浏览器引擎:%s,用户代理(User-Agent):[%s]"
     */
    public static String getDevice(String userAgent) {
        try {
            //解析agent字符串
            UserAgent ua = UserAgent.parseUserAgentString(userAgent);
            //获取浏览器对象
            Browser browser = ua.getBrowser();
            //获取操作系统对象
            OperatingSystem os = ua.getOperatingSystem();
            return String.format("设备类型:%s,操作系统:%s,浏览器:%s,浏览器版本:%s,浏览器引擎:%s,用户代理(User-Agent):[%s]",
                    os.getDeviceType(),
                    os.getName(),
                    browser.getName(),
                    browser.getVersion(userAgent),
                    browser.getRenderingEngine(),
                    userAgent
            );
        } catch (Exception e) {
            e.printStackTrace();
            return "没有任何登录设备信息";
        }
    }
}
