/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.ip.util;

import cn.tworice.common.util.StringUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

public class IpAddrUtils {
    public static String getIpAddr(HttpServletRequest request) {
        String Xip = request.getHeader("X-Real-IP");
        String XFor = request.getHeader("X-Forwarded-For");
        if (!StringUtils.isEmpty((String)XFor) && !"unknown".equalsIgnoreCase(XFor)) {
            int index = XFor.indexOf(",");
            if (index != -1) {
                return XFor.substring(0, index);
            }
            return XFor;
        }
        XFor = Xip;
        if (!StringUtils.isEmpty((String)XFor) && !"unknown".equalsIgnoreCase(XFor)) {
            return XFor;
        }
        if (StringUtils.isBlank((String)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getRemoteAddr();
        }
        return XFor;
    }

    public static long IPToLong(String ip) {
        double num = 0.0;
        if (!StringUtils.isEmpty((String)ip)) {
            String[] ipBytes = ip.split("\\.");
            for (int i = ipBytes.length - 1; i >= 0; --i) {
                num += (double)(Integer.parseInt(ipBytes[i]) % 256) * Math.pow(256.0, 3 - i);
            }
        }
        return (long)num;
    }

    public static String getIP(InetAddress inetAddress) {
        return inetAddress.getHostAddress();
    }

    public static String getIP_INFO(String ip) {
        try {
            String urlStr = "http://ip.taobao.com/service/getIpInfo.php?ip=" + ip;
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            if (conn.getResponseCode() == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                reader.close();
                String result = sb.toString();
                String country = result.split(":")[7].split(",")[0].replaceAll("\"", "");
                String region = result.split(":")[11].split(",")[0].replaceAll("\"", "");
                String city = result.split(":")[15].split(",")[0].replaceAll("\"", "");
                System.out.println("\u5f52\u5c5e\u5730\uff1a" + country + region + city);
            } else {
                System.out.println("\u67e5\u8be2\u5931\u8d25\uff0c\u54cd\u5e94\u7801\u4e3a\uff1a" + conn.getResponseCode());
            }
        }
        catch (Exception e) {
            System.out.println("\u67e5\u8be2\u5931\u8d25\uff0c" + e.getMessage());
        }
        return null;
    }
}

