package cn.tworice.file.service;

import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.file.constand.ShareStateConst;
import cn.tworice.file.dao.SystemFileDao;
import cn.tworice.file.dao.po.SystemFileDO;
import cn.tworice.mybatis.query.MPJLambdaWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import cn.tworice.upload.service.UploadService;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class SystemFileService implements InductsListenerService<SystemFileDO> {

    @Resource
    private SystemFileDao dao;

    @Resource
    private UploadService uploadService;

    /**
     * 上传文件，不会新增到数据库
     * @param entity 文件信息
     * @param file 文件数据
     */
    public void addFile(SystemFileDO entity, MultipartFile file) {
        if (file == null || file.isEmpty()) {
            return;
        }
        entity.setSize(file.getSize());
        entity.setName(file.getOriginalFilename());
        entity.setPath(uploadService.uploadFile(file));
        if (entity.getParent() == null) {
            entity.setParent(1);
        }
        if(entity.getShare()==null){
            entity.setShare(0);
        }
    }

    public Map<String,Object> list(PageParam pageParam, SystemFileDO entity) {
        return dao.selectPage(pageParam,  new MPJLambdaWrapperX<SystemFileDO>()
                .eqIfPresent(SystemFileDO::getId, entity.getId())
                .likeIfPresent(SystemFileDO::getName, entity.getName())
                .eqIfPresent(SystemFileDO::getParent, entity.getParent())
                .eqIfPresent(SystemFileDO::getType, entity.getType())
                .eqIfPresent(SystemFileDO::getPwd, entity.getPwd())
                .eqIfPresent(SystemFileDO::getState, entity.getState())
                .eqIfPresent(SystemFileDO::getCreator, entity.getCreator())
                .orderByDesc(SystemFileDO::getUpdateTime)
        );
    }

    public int set(SystemFileDO entity) {
        if (entity.getId() == null) {
            return dao.insert(entity);
        } else {
            return dao.updateById(entity);
        }
    }

    public boolean update(SystemFileDO entity) {
        return dao.updateById(entity) == 1;
    }

    public int del(Integer[] ids) {
        return dao.deleteBatchIds(Arrays.asList(ids));
    }

    @Override
    public boolean saveBatch(List<SystemFileDO> list) {
        list.forEach(item -> {
            item.setCreateTime(System.currentTimeMillis());
        });

        return dao.insertBatch(list,list.size());
    }

    public SystemFileDO info(int id) {
        return dao.selectById(id);
    }

    /**
     * 取消分享
     * @param id 文件编号
     */
    public void cancelShare(Integer id) {
        SystemFileDO info = this.info(id);
        info.setShare(ShareStateConst.unshare);
        this.set(info);
    }
}