/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.auth.start;

import cn.tworice.auth.error.EasyAuthError;
import cn.tworice.auth.exception.AuthException;
import cn.tworice.common.util.NetworkUtil;
import cn.tworice.common.util.cryption.RSAUtils;
import cn.tworice.common.util.datatime.DateUtil;
import cn.tworice.common.util.file.FileUtils;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@WebListener
@Component
public class EasyAuthStartAuth
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(EasyAuthStartAuth.class);
    @Value(value="${tworice.easy.key}")
    private String key;
    @Value(value="${tworice.easy.authUrl}")
    private String authUrl;
    private final RestTemplate restTemplate = new RestTemplate();
    private String userCacheDir;

    public void contextInitialized(ServletContextEvent sce) {
        log.info("\u6821\u9a8c\u7cfb\u7edf");
        try {
            this.userCacheDir = FileUtils.getUserCacheDir() + File.separator + "EasyAuth";
            String token = this.getFilePathContent(this.userCacheDir + File.separator + "token");
            log.info("\u8bfb\u53d6\u672c\u5730\u7f13\u5b58Token\uff1a{}", (Object)token);
            if (token == null) {
                token = this.verifyKey(this.userCacheDir);
            }
            if (!this.verifyToken(token) && !this.verifyToken(token = this.verifyKey(this.userCacheDir))) {
                throw new AuthException("\u6821\u9a8c\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u5931\u8d25");
            throw new EasyAuthError(e.getMessage());
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        System.out.println("\u5173\u95edTomcat\u5bb9\u5668");
    }

    private boolean verifyToken(String token) {
        if (token.isEmpty()) {
            return false;
        }
        try {
            String privateKey = this.getPrivateKey();
            token = RSAUtils.decrypt((byte[])RSAUtils.stringToBytes((String)token), (String)privateKey);
            Algorithm algorithm = Algorithm.HMAC256((String)this.key);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            DecodedJWT decodedJWT = verifier.verify(token);
            return this.verifyTime(decodedJWT) && this.verifyMac(decodedJWT) && this.verifyKey(decodedJWT);
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
            return false;
        }
    }

    private boolean verifyTime(DecodedJWT decodedJWT) {
        long expirationDate = decodedJWT.getClaim("exp").asLong();
        log.info("\u7cfb\u7edf\u6709\u6548\u671f\u81f3\uff1a{}", (Object)DateUtil.formatDate((long)expirationDate));
        return expirationDate >= new Date().getTime();
    }

    private boolean verifyMac(DecodedJWT decodedJWT) throws AuthException {
        String macAddr = NetworkUtil.getWlanMAC();
        log.info("\u672c\u673aMac\u5730\u5740\uff1a{}", (Object)macAddr);
        String tokenMac = decodedJWT.getClaim("mac").asString();
        log.info("Token Mac\u5730\u5740\uff1a{}", (Object)tokenMac);
        return macAddr.equals(tokenMac);
    }

    private boolean verifyKey(DecodedJWT decodedJWT) {
        log.info("\u7cfb\u7edfKey\uff1a{}", (Object)this.key);
        String id = decodedJWT.getClaim("id").asString();
        log.info("Token Key:{}", (Object)id);
        return this.key.equals(id);
    }

    private String getPrivateKey() {
        return this.getFilePathContent(this.userCacheDir + File.separator + "private.key");
    }

    private String verifyKey(String userCacheDir) throws AuthException {
        String macAddr = NetworkUtil.getWlanMAC();
        String url = this.authUrl + "?key=" + this.key + "&mac=" + macAddr;
        log.info("\u6821\u9a8c\u5730\u5740\uff1a{}", (Object)url);
        HttpMethod method = HttpMethod.GET;
        ResponseEntity response = this.restTemplate.exchange(url, method, null, String.class, new Object[0]);
        String responseBody = (String)response.getBody();
        JSONObject result = JSONObject.parseObject((String)responseBody);
        JSONObject status = result.getJSONObject("status");
        if (status.getInteger("code") == 200) {
            String token = status.getString("message");
            this.printContent(userCacheDir + File.separator + "token", token);
            this.printContent(userCacheDir + File.separator + "private.key", result.getJSONObject("data").getString("privateKey"));
            return token;
        }
        throw new AuthException(status.getString("message"));
    }

    private String getMacAddr() throws AuthException {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(localHost);
            if (networkInterface != null) {
                byte[] macAddressBytes = networkInterface.getHardwareAddress();
                if (macAddressBytes != null) {
                    StringBuilder macAddressBuilder = new StringBuilder();
                    for (byte b : macAddressBytes) {
                        macAddressBuilder.append(String.format("%02X:", b));
                    }
                    String macAddress = macAddressBuilder.toString();
                    return macAddress.substring(0, macAddress.length() - 1);
                }
                throw new AuthException("\u65e0\u6cd5\u83b7\u53d6MAC\u5730\u5740");
            }
            throw new AuthException("\u65e0\u6cd5\u83b7\u53d6\u7f51\u7edc\u63a5\u53e3");
        }
        catch (SocketException | UnknownHostException e) {
            throw new AuthException("\u83b7\u53d6MAC\u5730\u5740\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private String getFilePathContent(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void printContent(String path, String content) throws AuthException {
        try {
            File file = new File(path);
            file.getParentFile().mkdirs();
            FileWriter fw = new FileWriter(file);
            PrintWriter writer = new PrintWriter(fw);
            writer.println(content);
            writer.close();
        }
        catch (IOException e) {
            throw new AuthException(e.getMessage());
        }
    }
}

