package cn.tworice.dict.web;


import cn.tworice.dict.dao.po.SystemDictDO;
import cn.tworice.common.util.excel.InductsListener;
import cn.tworice.common.vo.RequestResult;
import cn.tworice.dict.service.SystemDictService;
import cn.tworice.mybatis.vo.PageParam;
import com.alibaba.excel.EasyExcel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import javax.annotation.Resource;
import java.io.InputStream;

@RestController
@RequestMapping("/admin/dict")
@CrossOrigin
@Api(tags = "系统字典")
public class SystemDictController {

    @Resource
    private SystemDictService service;

    @GetMapping("list")
    @ApiOperation("通过条件查询获取列表")
    public RequestResult list(PageParam pageParam, @ApiParam("查询条件") SystemDictDO entity) {
        return RequestResult.success().setData(service.list(pageParam,entity));
    }

    @PostMapping("add")
    @ApiOperation("新增数据")
    public RequestResult add(SystemDictDO entity) {
        service.set(entity);
        return RequestResult.success();
    }

    @DeleteMapping("del")
    @ApiOperation("通过ID数组删除数据")
    public RequestResult del(@ApiParam("数据ID数组")
                             Integer[] ids) {
        service.del(ids);
        return RequestResult.success();
    }

    @PostMapping("inducts")
    @ApiOperation("通过Excel表格批量上传数据")
    public RequestResult inducts(@ApiParam("Excel文件")
                                 MultipartFile file) {
        try (InputStream inputStream = file.getInputStream()){
            EasyExcel.read(inputStream, SystemDictDO.class, new InductsListener(service)).sheet().doRead();
            return RequestResult.success("批量导入数据成功");
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @GetMapping("info")
    @ApiOperation("通过ID获取数据")
    public RequestResult info(Integer id) {
        return RequestResult.success().appendData("info", service.getInfo(id));
    }
}