package cn.tworice.dict.service;


import cn.tworice.dict.dao.po.SystemDictDO;
import cn.tworice.common.util.excel.InductsListenerService;
import cn.tworice.dict.dao.SystemDictDao;
import cn.tworice.mybatis.query.LambdaQueryWrapperX;
import cn.tworice.mybatis.vo.PageParam;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class SystemDictService extends ServiceImpl<SystemDictDao, SystemDictDO> implements InductsListenerService<SystemDictDO> {
    @Resource
    private SystemDictDao dao;

    public Map<String,Object> list(PageParam pageParam, SystemDictDO entity) {
        return dao.selectPage(pageParam,new LambdaQueryWrapperX<SystemDictDO>()
                .eqIfPresent(SystemDictDO::getId,entity.getId())
                .likeIfPresent(SystemDictDO::getName,entity.getName())
                .likeIfPresent(SystemDictDO::getLogo,entity.getLogo())
        );
    }

    public int set(SystemDictDO entity) {
        if (entity.getId() == null) {
            return dao.insert(entity);
        } else {
            return dao.updateById(entity);
        }
    }

    public int del(Integer[] ids) {
        return dao.deleteBatchIds(Arrays.asList(ids));
    }

    public boolean update(SystemDictDO entity) {
        return dao.updateById(entity)==1;
    }

    @Override
    public boolean saveBatch(List<SystemDictDO> list) {
        list.forEach(item -> {
            item.setCreateTime(System.currentTimeMillis());
        });

        return dao.insertBatch(list,list.size());
    }

    public SystemDictDO getInfo(Integer id) {
        return dao.selectById(id);
    }
}