/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.desensitize.base.serializer;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.lang.Singleton;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.tworice.desensitize.base.annotation.DesensitizeBy;
import cn.tworice.desensitize.base.handler.DesensitizationHandler;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;

public class StringDesensitizeSerializer
extends StdSerializer<String>
implements ContextualSerializer {
    private DesensitizationHandler desensitizationHandler;

    protected StringDesensitizeSerializer() {
        super(String.class);
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        DesensitizeBy annotation = (DesensitizeBy)beanProperty.getAnnotation(DesensitizeBy.class);
        if (annotation == null) {
            return this;
        }
        StringDesensitizeSerializer serializer = new StringDesensitizeSerializer();
        serializer.setDesensitizationHandler((DesensitizationHandler)Singleton.get(annotation.handler(), (Object[])new Object[0]));
        return serializer;
    }

    public void serialize(String value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        if (StrUtil.isBlank((CharSequence)value)) {
            gen.writeNull();
            return;
        }
        Field field = this.getField(gen);
        Object[] annotations = (DesensitizeBy[])AnnotationUtil.getCombinationAnnotations((AnnotatedElement)field, DesensitizeBy.class);
        if (ArrayUtil.isEmpty((Object[])annotations)) {
            gen.writeString(value);
            return;
        }
        for (Annotation annotation : field.getAnnotations()) {
            if (!AnnotationUtil.hasAnnotation(annotation.annotationType(), DesensitizeBy.class)) continue;
            value = this.desensitizationHandler.desensitize(value, annotation);
            gen.writeString(value);
            return;
        }
        gen.writeString(value);
    }

    private Field getField(JsonGenerator generator) {
        String currentName = generator.getOutputContext().getCurrentName();
        Object currentValue = generator.getCurrentValue();
        Class<?> currentValueClass = currentValue.getClass();
        return ReflectUtil.getField(currentValueClass, (String)currentName);
    }

    public DesensitizationHandler getDesensitizationHandler() {
        return this.desensitizationHandler;
    }

    public void setDesensitizationHandler(DesensitizationHandler desensitizationHandler) {
        this.desensitizationHandler = desensitizationHandler;
    }
}

