package cn.tworice.common.vo;

import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 控制层返回结果
 * @author 二饭[tworice@sina.cn][2022/1/15 11:09]
 */
public class RequestResult implements Serializable {
    private static final long serialVersionUID = 7270509107164711433L;

    private StatusCode status;

    private Map<String, Object> data;

    public RequestResult() {
        super();
        this.status = new StatusCode(StateCodeConst.SUCCESS, "请求成功");
        data = new HashMap<>();
    }

    public RequestResult(StatusCode status){
        super();
        this.status = status;
        data = new HashMap<>();
    }

    public RequestResult(int code, String message){
        super();
        this.status = new StatusCode(code, message);
        data = new HashMap<>();
    }

    public StatusCode getStatus() {
        return status;
    }

    public void setStatus(StatusCode status) {
        this.status = status;
    }

    public Map<String, Object> getData() {
        return data;
    }

    public RequestResult setData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public RequestResult appendData(String key, Object value){
        this.data.put(key, value);
        return this;
    }

    public void removeData(String key){
        this.data.remove(key);
    }

    public void clearData(){
        this.data.clear();
    }

    public static RequestResult success() {
        return new RequestResult();
    }

    public static RequestResult success(Integer code){
        return new RequestResult(code,"请求成功");
    }

    public static RequestResult success(Integer code,String msg){
        return new RequestResult(code,msg);
    }

    public static RequestResult success(Map<String, Object> data) {
        RequestResult result = new RequestResult();
        result.setData(data);
        return result;
    }

    public static RequestResult success(String msg) {
        return new RequestResult(StateCodeConst.SUCCESS,msg);
    }

    public static RequestResult error() {
        return new RequestResult(StateCodeConst.ERROR, "请求出错");
    }

    public static RequestResult error(String message) {
        return new RequestResult(StateCodeConst.ERROR, message);
    }

    public static RequestResult error(Integer code,String message) {
        return new RequestResult(code, message);
    }


    @Data
    @AllArgsConstructor
    static class StatusCode implements Serializable {
        private static final long serialVersionUID = -4213573961876598438L;
        /**
         * 状态码
         */
        protected Integer code;
        /**
         * 状态信息
         */
        protected String message;
        public StatusCode() {
        }
    }
}
