package cn.tworice.common.util.file;


import cn.tworice.common.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import java.awt.image.BufferedImage;
import java.io.*;
import java.nio.channels.FileChannel;

public class FileUtils {
    /**
     * 将文件复制到指定目录
     * @param source 文件
     * @param dest 目标目录
     * @author 二饭 [2023/1/13]
     **/
    public static void copyFileUsingFileChannels(File source, File dest) throws IOException {
        FileChannel inputChannel = null;
        FileChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(source).getChannel();
            outputChannel = new FileOutputStream(dest).getChannel();
            outputChannel.transferFrom(inputChannel, 0, inputChannel.size());
        } finally {
            inputChannel.close();
            outputChannel.close();
        }
    }

    /**
     * 获取用户级缓存目录
     * @return java.lang.String
     * @author 二饭 [2023/6/16]
     **/
    public static String getUserCacheDir(){
        String osName = System.getProperty("os.name").toLowerCase();
        String path = System.getProperty("user.home") + File.separator;
        if (osName.contains("win")) {
            path += "AppData" + File.separator + "Local" + File.separator;
        } else if (osName.contains("mac")) {
            path += "Library" + File.separator + "Caches" + File.separator;
        } else if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            path += ".cache" + File.separator;
        } else {
            System.out.println("无法确定当前操作系统");
        }
        return path;

    }

    /**
     * 将文本内容输出到指定文件中
     *
     * @param content  文本内容
     * @param filePath 文件路径
     * @param append   是否追加
     * @author 二饭 [2023/9/15]
     **/
    public static void writeToFile(String content, String filePath, boolean append) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filePath, append));
            writer.write(content);
            writer.newLine();
            writer.close();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 获取应用目录
     * @return 应用目录
     */
    public static String getApplicationHome() {
        String applicationHome = System.getProperty("application_home");
        applicationHome = applicationHome == null ? System.getenv("application_home") : applicationHome;
        applicationHome = StringUtils.isEmpty(applicationHome) ? System.getProperty("user.dir") : applicationHome;
        return applicationHome;
    }

    /**
     * 读取文件内容
     * @param filePath 文件路径
     * @return 文件内容
     */
    public static String readFile(String filePath) {
        StringBuilder content = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(filePath))) {
            String line;
            while ((line = br.readLine()) != null) {
                content.append(line).append("\n");
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return content.toString();
    }
}
