package cn.tworice.common.util.cryption;

import org.springframework.util.DigestUtils;

/**
 * MD5加密
 *
 * @author 二饭 [2023/1/7]
 **/
public class MD5Utils {

    /**
     * 利用SpringCore进行MD5加密
     *
     * @param pwd 密码
     * @return java.lang.String 加密后的内容
     * @author 二饭 [2023/1/7]
     **/
    public static String getMd5Plus(String pwd) {

        String md1 = DigestUtils.md5DigestAsHex(pwd.getBytes());

        String substring6 = md1.substring(0, 6);

        return DigestUtils.md5DigestAsHex((md1 + substring6).getBytes());
    }

    public static void main(String[] args) {
        String content = "现在是2023年2月27日";
        System.out.println(MD5Utils.getMd5Plus(content));
    }
}
