package cn.tworice.common.util;

import com.sun.management.OperatingSystemMXBean;
import lombok.extern.slf4j.Slf4j;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.*;

@Slf4j
public class SystemInfoUtil {

    Properties properties = null;

    public SystemInfoUtil(){
        this.properties = System.getProperties();
    }

    class InfoEntry{
        String key;
        String value;

        InfoEntry(String key,String value){
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return "InfoEntry{" +
                    "key='" + key + '\'' +
                    ", value='" + value + '\'' +
                    '}';
        }
    }

    /**
     * 获取系统和JVM信息
     * @author 二饭
     */
    public List<SystemInfoUtil.InfoEntry> getSystemInfo(){
        List<SystemInfoUtil.InfoEntry> list = new ArrayList<>();
        try {
            list.add(new InfoEntry("系统信息", properties.getProperty("os.name")));
            list.add(new InfoEntry("系统用户", properties.getProperty("user.name")));
            list.add(new InfoEntry("处理器型号", properties.getProperty("os.arch")));
            list.add(new InfoEntry("文件编码格式", properties.getProperty("file.encoding")));
            list.add(new InfoEntry("Java版本", properties.getProperty("java.version")));
            list.add(new InfoEntry("JVM名称", properties.getProperty("java.vm.name")));
            list.add(new InfoEntry("JVM工作模式", properties.getProperty("java.vm.info")));
        }catch (Exception ex){
            log.warn("读取系统信息时出现异常");
        }
        return list;
    }

    /**
     * 获取系统物理内存信息
     * @author 二饭[tworice@sina.cn][2022/1/7 21:17]
     */
    public List getMemoryInfo(){
        List<Map<String, Object>> list = new ArrayList<>();
        OperatingSystemMXBean osmb = (OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();
        Map<String, Object> map = new HashMap<>();
        map.put("totalMemory", osmb.getTotalPhysicalMemorySize() / 1024 / 1024);
        map.put("availableMemory", osmb.getFreePhysicalMemorySize() / 1024/1024);
        list.add(map);
        return list;
    }

    /**
     * 获取当前进程信息
     * @author 二饭[tworice@sina.cn][2022/1/8 10:43]
     */
    public List getProcessInfo(){
        List<Map<String, Object>> list = new ArrayList<>();
        // 获取进程名称
        Map<String, Object> runName = new HashMap<>();
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        runName.put("key", "应用进程");
        runName.put("value", runtime.getName());
        list.add(runName);

        // 获取进程中的线程数量
        Map<String, Object> threadMap = new HashMap<>();
        Map <Thread, StackTraceElement[] > maps = Thread.getAllStackTraces();
        threadMap.put("key", "应用线程数");
        threadMap.put("value", maps.size());
        list.add(threadMap);

        // 获取当前进程使用内存
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        Map<String, Object> map1 = new HashMap<>();
        map1.put("key", "应用申请内存");
        map1.put("value", heapMemoryUsage.getCommitted()/1024/1024+"MB");
        list.add(map1);
        Map<String, Object> map2 = new HashMap<>();
        map2.put("key", "应用已使用内存");
        map2.put("value", heapMemoryUsage.getUsed()/1024/1024+"MB");
        list.add(map2);
        Map<String, Object> map3 = new HashMap<>();
        map3.put("key", "应用最大可使用内存");
        map3.put("value", heapMemoryUsage.getMax()/1024/1024+"MB");
        list.add(map3);

        return list;
    }

    /**
     * 获取CPU信息
     * @author 二饭[tworice@sina.cn][2022/1/8 13:07]
     */
    public List getCpuInfo(){
        OperatingSystemMXBean os =(OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("systemCpuLoad", os.getSystemCpuLoad());// 系统CPU使用率
        map.put("processCpuLoad", os.getProcessCpuLoad());// JVM CPU使用率
        list.add(map);
        return list;
    }

    /**
     * 获取Mac地址
     * @return java.lang.String
     * @author 二饭 [2023/6/20]
     **/
    public static String getMacAddr(){
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(localHost);

            if (networkInterface != null) {
                byte[] macAddressBytes = networkInterface.getHardwareAddress();

                if (macAddressBytes != null) {
                    StringBuilder macAddressBuilder = new StringBuilder();

                    for (byte b : macAddressBytes) {
                        macAddressBuilder.append(String.format("%02X:", b));
                    }

                    String macAddress = macAddressBuilder.toString();
                    return macAddress.substring(0, macAddress.length() - 1);
                } else {
                    throw new RuntimeException("无法获取MAC地址");
                }
            } else {
                throw new RuntimeException("无法获取网络接口");
            }
        } catch (UnknownHostException | SocketException e) {
            throw new RuntimeException("获取MAC地址时发生错误: " + e.getMessage());
        }
    }
}
