package cn.tworice.common.util;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private final static Pattern linePattern = Pattern.compile("_(\\w)");
    private final static Pattern humpPattern = Pattern.compile("[A-Z]");

    /**
     * 下划线转驼峰,首字母小写
     * @param str 下划线变量名
     * @return 驼峰变量名
     */
    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /**
     * 下划线转驼峰,首字母大写
     * @param str 下划线变量名
     * @return 驼峰变量名
     */
    public static String lineToHump2(String str) {
        String s = StringUtils.lineToHump(str);
        String s1 = String.valueOf(s.charAt(0)).toUpperCase();
        return s1+s.substring(1);
    }

    /**
     * 驼峰转下划线
     * @param str 驼峰变量名
     * @return 下划线变量名
     */
    public static String humpToLine(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /**
     * 生成去除符号的UUID
     * @return java.lang.String
     **/
    public static String generateUuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    /**
     * 判断字符串是否为空或空格
     * @param str 目标字符串
     * @return 是否为空
     */
    public static boolean isBlank(String str) {
        int length;
        if (str != null && (length = str.length()) != 0) {
            for(int i = 0; i < length; ++i) {
                if (!CharUtil.isBlankChar(str.charAt(i))) {
                    return false;
                }
            }
            return true;
        } else {
            return true;
        }
    }

    /**
     * 将一个字符串的指定部分替换为另一个字符串
     * @param originalString 原始字符串
     * @param startIdx 开始索引
     * @param endIdx 结束索引
     * @param replacement 要替换的字符串
     * @return 结果字符串
     */
    public static String replaceSubstring(String originalString, int startIdx, int endIdx, String replacement) {
        if (originalString == null || replacement == null || startIdx < 0 || endIdx >= originalString.length() || startIdx > endIdx) {
            throw new IllegalArgumentException("Invalid parameters");
        }

        // 分割字符串为三部分：前缀、中间部分和后缀
        String prefix = originalString.substring(0, startIdx);
        String suffix = originalString.substring(endIdx + 1);

        // 重新组合字符串
        return prefix + replacement + suffix;
    }

    /**
     * 判断字符串是否包含指定字符串
     * @param str 长字符串
     * @param searchStr 短字符串
     * @return 是否包含
     */
    public static boolean contains(CharSequence str, CharSequence searchStr) {
        return null != str && null != searchStr && str.toString().contains(searchStr);
    }
}
