package cn.tworice.common.util;

import java.util.regex.Pattern;

/**
 * 常用正则表达式
 * @author 二饭 [2022/11/18]
 **/
public enum RegularTable {

    /** 电话号码 */
    PHONE{
        public String getRegular() {
            return "^1[35789]\\d{9}$";
        }
    },

    /** 邮箱地址 */
    EMAIL {
        public String getRegular() {
            return "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
        }
    },

    /** 身份证号码 */
    IDCard {
        public String getRegular() {
            return "^\\d{15}|\\d{18}$";
        }
    },

    /** IP地址 */
    IPAddr {
        public String getRegular() {
            return "\\d+\\.\\d+\\.\\d+\\.\\d+";
        }
    },

    /** 只能判断纯中文，中文标点符号不行 */
    Chinese {
        public String getRegular() {
            return "^[\\u4e00-\\u9fa5]+$";
        }
    },

    /** 匹配强密码 包含大小写字母和数字的组合，不能使用特殊字符，长度在8-10之间 */
    STRONG_PASSWORD {
        public String getRegular() {
            return "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,10}$";
        }
    };

    public abstract String getRegular();

    /**
     * 正则判断
     * @param str 传入的字符串
     * @return boolean 判断结果
     * @author 二饭 [2022/11/18]
     **/
    public boolean verify(String str){
        return Pattern.matches(this.getRegular(), str);
    };
}
