package cn.tworice.source;

import javax.tools.SimpleJavaFileObject;
import java.net.URI;

/**
 * 封装源代码
 */
public class StringJavaSource extends SimpleJavaFileObject {
    private final String code;

    public StringJavaSource(String name, String code) {
        super(URI.create("string:///" + name.replace('.', '/') + Kind.SOURCE.extension), Kind.SOURCE);
        this.code = code;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return code;
    }
}
