/*
 * Decompiled with CFR 0.152.
 */
package cn.tworice.pay.alipay.service;

import cn.tworice.common.util.StringUtils;
import cn.tworice.pay.alipay.exception.AlipayException;
import cn.tworice.pay.alipay.vo.AlipayQueryVO;
import cn.tworice.pay.alipay.vo.AlipayRefundVO;
import cn.tworice.pay.alipay.vo.AlipayVO;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="alipayService")
public class AlipayService {
    private static final Logger log = LoggerFactory.getLogger(AlipayService.class);
    @Resource
    private AlipayClient alipayClient;

    public String pay(AlipayVO alipayVO) {
        AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
        alipayRequest.setReturnUrl(alipayVO.getReturnUrl());
        alipayRequest.setNotifyUrl(alipayVO.getNotifyUrl());
        alipayRequest.setBizContent("{\"out_trade_no\":\"" + alipayVO.getOutTradeNo() + "\",\"total_amount\":\"" + alipayVO.getTotalAmount() + "\",\"subject\":\"" + alipayVO.getSubject() + "\",\"body\":\"" + alipayVO.getBody() + "\",\"product_code\":\"FAST_INSTANT_TRADE_PAY\"}");
        String result = null;
        try {
            result = ((AlipayTradePagePayResponse)this.alipayClient.pageExecute((AlipayRequest)alipayRequest)).getBody();
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            log.error("=====================\u652f\u4ed8\u5b9d\u652f\u4ed8\u9a8c\u8bc1\u4fe1\u606f\u6709\u8bef\uff0c\u8fd8\u6ca1\u6709\u5230\u652f\u4ed8\u754c\u9762======================");
        }
        log.info(result);
        log.info("=====================\u652f\u4ed8\u5b9d\u652f\u4ed8\u9a8c\u8bc1\u4fe1\u606f\u6b63\u786e\uff0c\u8df3\u8f6c\u5230\u652f\u4ed8\u754c\u9762======================");
        return result;
    }

    public String queryPay(AlipayQueryVO alipayQueryVO) throws AlipayApiException {
        AlipayTradeQueryRequest alipayRequest = new AlipayTradeQueryRequest();
        if (!StringUtils.isBlank((String)alipayQueryVO.getOutTradeNo())) {
            alipayRequest.setBizContent("{\"out_trade_no\":\"" + alipayQueryVO.getOutTradeNo() + "\"}");
        } else if (!StringUtils.isBlank((String)alipayQueryVO.getTrade_no())) {
            alipayRequest.setBizContent("{\"trade_no\":\"" + alipayQueryVO.getTrade_no() + "\"}");
        } else {
            throw new AlipayException("\u8ba2\u5355\u53f7\u4e0e\u4ea4\u6613\u53f7\u5fc5\u987b\u4e8c\u9009\u4e00");
        }
        return ((AlipayTradeQueryResponse)this.alipayClient.execute((AlipayRequest)alipayRequest)).getBody();
    }

    public String refund(AlipayRefundVO alipayVO) throws AlipayApiException {
        AlipayTradeQueryRequest alipayRequest = new AlipayTradeQueryRequest();
        if (!StringUtils.isBlank((String)alipayVO.getOutTradeNo())) {
            alipayRequest.setBizContent("{\"out_trade_no\":\"" + alipayVO.getOutTradeNo() + "\",\"refund_amount\":\"" + alipayVO.getRefundAmount() + "\",\"refund_reason\":\"" + alipayVO.getRefundReason() + "\",\"out_request_no\":\"" + alipayVO.getOutRequestNo() + "\"}");
        } else if (!StringUtils.isBlank((String)alipayVO.getTrade_no())) {
            alipayRequest.setBizContent("{\"trade_no\":\"" + alipayVO.getTrade_no() + "\",\"refund_amount\":\"" + alipayVO.getRefundAmount() + "\",\"refund_reason\":\"" + alipayVO.getRefundReason() + "\",\"out_request_no\":\"" + alipayVO.getOutRequestNo() + "\"}");
        } else {
            throw new AlipayException("\u8ba2\u5355\u53f7\u4e0e\u4ea4\u6613\u53f7\u5fc5\u987b\u4e8c\u9009\u4e00");
        }
        return ((AlipayTradeQueryResponse)this.alipayClient.execute((AlipayRequest)alipayRequest)).getBody();
    }
}

