package cn.tworice.pay.alipay.service;

import cn.tworice.common.util.StringUtils;
import cn.tworice.pay.alipay.exception.AlipayException;
import cn.tworice.pay.alipay.vo.AlipayQueryVO;
import cn.tworice.pay.alipay.vo.AlipayRefundVO;
import cn.tworice.pay.alipay.vo.AlipayVO;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service("alipayService")
@Slf4j
public class AlipayService {

    @Resource
    private AlipayClient alipayClient;

    public String pay(AlipayVO alipayVO) {
        //设置请求参数
        AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
        alipayRequest.setReturnUrl(alipayVO.getReturnUrl());
        alipayRequest.setNotifyUrl(alipayVO.getNotifyUrl());

        alipayRequest.setBizContent("{\"out_trade_no\":\"" + alipayVO.getOutTradeNo() + "\","
                + "\"total_amount\":\"" + alipayVO.getTotalAmount() + "\","
                + "\"subject\":\"" + alipayVO.getSubject() + "\","
                + "\"body\":\"" + alipayVO.getBody() + "\","
                + "\"product_code\":\"FAST_INSTANT_TRADE_PAY\"}");

        // 请求
        String result = null;
        try {
            result = alipayClient.pageExecute(alipayRequest).getBody();
        } catch (AlipayApiException e) {
            e.printStackTrace();
            log.error("=====================支付宝支付验证信息有误，还没有到支付界面======================");
        }
        //结果返回
        log.info(result);
        log.info("=====================支付宝支付验证信息正确，跳转到支付界面======================");
        return result;
    }

    /**
     * 查询交易订单
     * @param alipayQueryVO 查询条件
     * @return java.lang.String 查询结果
     * @author 二饭 [2023/1/13]
     **/
    public String queryPay(AlipayQueryVO alipayQueryVO) throws AlipayApiException {
        // 设置请求参数
        AlipayTradeQueryRequest alipayRequest = new AlipayTradeQueryRequest();
        if (!StringUtils.isBlank(alipayQueryVO.getOutTradeNo())) {
            alipayRequest.setBizContent("{\"out_trade_no\":\""+ alipayQueryVO.getOutTradeNo() +"\"}");
        } else if (!StringUtils.isBlank(alipayQueryVO.getTrade_no())) {
            alipayRequest.setBizContent("{\"trade_no\":\"" + alipayQueryVO.getTrade_no() + "\"}");
        } else {
            throw new AlipayException("订单号与交易号必须二选一");
        }
        return alipayClient.execute(alipayRequest).getBody();
    }

    public String refund(AlipayRefundVO alipayVO) throws AlipayApiException {
        // 设置请求参数
        AlipayTradeQueryRequest alipayRequest = new AlipayTradeQueryRequest();
        if (!StringUtils.isBlank(alipayVO.getOutTradeNo())) {
            alipayRequest.setBizContent("{\"out_trade_no\":\""+ alipayVO.getOutTradeNo() +"\","
                    + "\"refund_amount\":\""+ alipayVO.getRefundAmount() +"\","
                    + "\"refund_reason\":\""+ alipayVO.getRefundReason() +"\","
                    + "\"out_request_no\":\""+ alipayVO.getOutRequestNo() +"\"}");
        } else if (!StringUtils.isBlank(alipayVO.getTrade_no())) {
            alipayRequest.setBizContent("{\"trade_no\":\""+ alipayVO.getTrade_no() +"\","
                    + "\"refund_amount\":\""+ alipayVO.getRefundAmount() +"\","
                    + "\"refund_reason\":\""+ alipayVO.getRefundReason() +"\","
                    + "\"out_request_no\":\""+ alipayVO.getOutRequestNo() +"\"}");
        } else {
            throw new AlipayException("订单号与交易号必须二选一");
        }

        return alipayClient.execute(alipayRequest).getBody();
    }
}
