package cn.tworice.pay.alipay.controller;

import cn.tworice.common.vo.RequestResult;
import cn.tworice.pay.alipay.service.AlipayService;
import cn.tworice.pay.alipay.util.PayUtils;
import cn.tworice.pay.alipay.vo.AlipayQueryVO;
import cn.tworice.pay.alipay.vo.AlipayRefundVO;
import cn.tworice.pay.alipay.vo.AlipayVO;
import com.alipay.api.AlipayApiException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(tags = "支付宝支付")
@RestController
@RequestMapping("/pay")
@CrossOrigin
public class AliPayController {

    @Resource
    private AlipayService alipayService;

    @ApiOperation(value = "支付")
    @PostMapping("/aliPay")
    public RequestResult aliPay(AlipayVO aliPayPojo) {

        //支付封装结果返回
        RequestResult result = RequestResult.success()
                .appendData("content", alipayService.pay(aliPayPojo));
        //...写你的业务逻辑:健壮性的判断、生成某某东西入库等等

        //我这里简单粗暴，直接返回字符串，前端解析.....
        return result;
    }

    @ApiOperation(value = "查询支付订单")
    @PostMapping("/query")
    public RequestResult queryPay(AlipayQueryVO alipayQueryVO) throws AlipayApiException {
        return RequestResult.success()
                .appendData("content", alipayService.queryPay(alipayQueryVO));
    }

    @ApiOperation(value = "订单退款")
    @PutMapping("/refund")
    public RequestResult refund(@Validated AlipayRefundVO alipayRefundVO) throws AlipayApiException {
        return RequestResult.success()
                .appendData("content", alipayService.refund(alipayRefundVO));
    }
}
