package cn.tworice.pay.alipay.config;

import lombok.Data;
import org.hibernate.validator.constraints.URL;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@ConfigurationProperties(prefix = "tworice.alipay")
@Data
@Component("alipayProperties")
public class AlipayProperties {
    /**
     * 应用ID，收款账号既是您的APPID对应支付宝账号
     **/
    private String appid;

    /**
     * 字符编码格式
     **/
    private String charset = "utf-8";

    /**
     * 签名方式
     **/
    private String signType = "RSA2";

    /**
     * 支付宝网关
     **/
    private String gatewayUrl = "https://openapi-sandbox.dl.alipaydev.com/gateway.do";

    /**
     * 格式
     **/
    private String format = "json";

    /**
     * 商户私钥
     */
    private String merchantPrivateKey = "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCWhOQHKo2YVV0d1KyKLm5Az5us1UMba2I/6URDiXUO8bQY7vN74FVX038Zscb15hJDp4saJJvzp7/hbTMEXqB4pTCguBe/mzJch7/G0V1A87C5c5+CIzIfMWRqfkVsZL3qzlUZ2mzFmsoYPgIF4XU8XS8CjT3yZdBy245iRQyHDj5Nys3e3swZG0bWWnK8vsra9QPoZ6m6ZlXdmOp42HjB/Vun557NOblSuJOws3/elZQLf4j5GSNvd+DlFssi+IEPv8hIGa1tfapybVqJxF7AirHmJQtyRulyNhtLiGAX4sBERbUjuVsvSilPmkmaSYk+hz9TBNOkaH6IFynDwR6lAgMBAAECggEAQ+P81h6jbypRrbrXeBwpLqJ1nScz9ZIh5qHYYH4Hho4OpZBh0mYFGHAUzAobq53ybwGLBGeuz9/B9HPEpxvnVYNsw5FFZO8jcAjqv0p/vWQtOfik4ZXubZNhr4b02Uc3Qkl+qQKUPSzsKrMNRonCz09YfNYoMsUpmCTfvANY+zEFsygZsc9Tw5W5e+cT5M0/T+GFTgBWgboiQVYMhL+GTAvKZxvEJsSqaoKsKzXdnfgQ4fQNMFVAvI+04NaoPH78I2fnOl8mje27FJLHVI0fWRdtmthfHmHg5fYn6XO5vQd2m3m31FEnuojNsdsHOd3t+pC6Oikt9TLli59S5FQUAQKBgQDppc+QfWEM3vbLuyoiTMH3dkdGu7sJEHHNKac67vdrotfVzs/hvHUpUzZfYAbZZ16KNmSIxUoaPhBXUerutbGHhM98iCc/K68WahCjH6de579pqadCGUEch3UYVbCTx48qFdh8/pL8NFtxjiytYxZqNRoPcE580zIzamjLESD3YQKBgQCk6zRs5G1HV7afrGaQfY6hZV1Bt3fdRLo7j6MjN3eB1RCuoWe7YXmoUs/QAw9fAHv8GNJC4j3hEAGcI1F46NC0GcPLJCTcTa+9GPB2gJd1KHrbKltWAK2tz3b3dng6vnnMnLjY97EcBWO8BzCQDHoRc/6js5IIriXHxL/F1AdhxQKBgAzx6dkYiTr8U3IgMYpq9EgwnmxV1FwBNDzotOI4AS9Oe2TWK4BXP6qFeLq6CEcdSgigUNufCqb/j0o3OKv3FxnqCtDcfkgqtG2qfLd89nn0nw9Mnf60hX3+J0es37agVNdBFJiARkaA5Bwbg3Ar0D8cKBB46XBTBzIAEERH86qhAoGAA8t1tVu8N/wIs7vf0EtTUNtoPe7ezzSZpG01r8XC9jXU4G/OVz1y8zCUn5CyddkpATABBpD2I4uevd0CLuoMg1hkbPQz9O3EsXE1d0SWN5fq28gpudziIjG35xHOyms/mjmw9y0b4i0tklIICAiBdo1YuqOTJKf9Lo+UahTq5pECgYAnYgfFSihcxAdnHUn44FFLuW6whdUnIcvZiBQ4zo6kMRyvOTQhNhq7+q9o2UklH1614CcHTkQhSf1LIhS4boUjKNt2olPcvkPtURdbL3qK8Ge6RBFpTbNmPTrtnRdTrmEGjIkwqCCD9F9PbkluqD4HMIdU+IqMZMBI3v8IL/kFig==";

    /**
     * 支付宝公钥
     */
    private String publicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoiHlfEc9trwBk4gBzVhgEhnRNiG42Z4R+RIK/cJGVU06hy0KYrpcJRZ43KLOaYCqcaMTNrzZ+aNJO+JoFKqKbQlcytpTM0cup69+LjkhgE1fn+HroJYlOTDfQDEdp11bBKC7w9mMmsDgXCbfismgX/ileSTXN4X9gwgbS0e4WUM1cLhZ4nE7SUmar4BXrjO0ckXtFa4spA3rrKG0S3dJsMehJKuBO8Zf8/7qat7xBEHyqZqSnFK2mmFJM/PXzkEjkau1utiXkQTFRTrTOcxDmbH7Y5rqr7g5Mp7l/xzrkDCje+7Guu8stuQjtcdY/+A1bymF31NMIMHy/prqo4CkSQIDAQAB";

    /**
     * 服务器异步通知页面路径  需http://格式的完整路径，不能加?id=123这类自定义参数，必须外网可以正常访问
     **/
//    @URL(message = "服务器异步回调地址的格式必须是 URL")
//    @NotNull
//    public String notifyUrl;
//
//    /**
//     * 页面跳转同步通知页面路径 需http://格式的完整路径，不能加?id=123这类自定义参数，必须外网可以正常访问
//     **/
//    @NotNull
//    @URL(message = "支付回调页面跳转同步通知地址的格式必须是 URL")
//    public String returnUrl;


}
