/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.websocket.netty.domain;

import cn.twelvet.websocket.netty.annotation.BeforeHandshake;
import cn.twelvet.websocket.netty.annotation.OnBinary;
import cn.twelvet.websocket.netty.annotation.OnClose;
import cn.twelvet.websocket.netty.annotation.OnError;
import cn.twelvet.websocket.netty.annotation.OnEvent;
import cn.twelvet.websocket.netty.annotation.OnMessage;
import cn.twelvet.websocket.netty.annotation.OnOpen;
import cn.twelvet.websocket.netty.exception.WebSocketException;
import cn.twelvet.websocket.netty.support.MethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.ByteMethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.EventMethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.HttpHeadersMethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.PathVariableMapMethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.PathVariableMethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.RequestParamMapMethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.RequestParamMethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.SessionMethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.TextMethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.ThrowableMethodArgumentResolver;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;

public class WebSocketMethodMapping {
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final Method beforeHandshake;
    private final Method onOpen;
    private final Method onClose;
    private final Method onError;
    private final Method onMessage;
    private final Method onBinary;
    private final Method onEvent;
    private final MethodParameter[] beforeHandshakeParameters;
    private final MethodParameter[] onOpenParameters;
    private final MethodParameter[] onCloseParameters;
    private final MethodParameter[] onErrorParameters;
    private final MethodParameter[] onMessageParameters;
    private final MethodParameter[] onBinaryParameters;
    private final MethodParameter[] onEventParameters;
    private final MethodArgumentResolver[] beforeHandshakeArgResolvers;
    private final MethodArgumentResolver[] onOpenArgResolvers;
    private final MethodArgumentResolver[] onCloseArgResolvers;
    private final MethodArgumentResolver[] onErrorArgResolvers;
    private final MethodArgumentResolver[] onMessageArgResolvers;
    private final MethodArgumentResolver[] onBinaryArgResolvers;
    private final MethodArgumentResolver[] onEventArgResolvers;
    private final Class<?> webSocketClazz;
    private final ApplicationContext applicationContext;
    private final AbstractBeanFactory beanFactory;

    public WebSocketMethodMapping(Class<?> webSocketClazz, ApplicationContext context, AbstractBeanFactory beanFactory) throws WebSocketException {
        this.applicationContext = context;
        this.webSocketClazz = webSocketClazz;
        this.beanFactory = beanFactory;
        Method handshake = null;
        Method open = null;
        Method close = null;
        Method error = null;
        Method message = null;
        Method binary = null;
        Method event = null;
        Method[] webSocketClazzMethods = null;
        Class<?> currentClazz = webSocketClazz;
        while (!currentClazz.equals(Object.class)) {
            Method[] currentClazzMethods = currentClazz.getDeclaredMethods();
            if (currentClazz == webSocketClazz) {
                webSocketClazzMethods = currentClazzMethods;
            }
            for (Method method : currentClazzMethods) {
                if (method.getAnnotation(BeforeHandshake.class) != null) {
                    this.checkIsPublic(method);
                    if (handshake == null) {
                        handshake = method;
                        continue;
                    }
                    if (currentClazz != webSocketClazz && this.isMethodOverride(handshake, method)) continue;
                    throw new WebSocketException("duplicateAnnotation BeforeHandshake");
                }
                if (method.getAnnotation(OnOpen.class) != null) {
                    this.checkIsPublic(method);
                    if (open == null) {
                        open = method;
                        continue;
                    }
                    if (currentClazz != webSocketClazz && this.isMethodOverride(open, method)) continue;
                    throw new WebSocketException("duplicateAnnotation OnOpen");
                }
                if (method.getAnnotation(OnClose.class) != null) {
                    this.checkIsPublic(method);
                    if (close == null) {
                        close = method;
                        continue;
                    }
                    if (currentClazz != webSocketClazz && this.isMethodOverride(close, method)) continue;
                    throw new WebSocketException("duplicateAnnotation OnClose");
                }
                if (method.getAnnotation(OnError.class) != null) {
                    this.checkIsPublic(method);
                    if (error == null) {
                        error = method;
                        continue;
                    }
                    if (currentClazz != webSocketClazz && this.isMethodOverride(error, method)) continue;
                    throw new WebSocketException("duplicateAnnotation OnError");
                }
                if (method.getAnnotation(OnMessage.class) != null) {
                    this.checkIsPublic(method);
                    if (message == null) {
                        message = method;
                        continue;
                    }
                    if (currentClazz != webSocketClazz && this.isMethodOverride(message, method)) continue;
                    throw new WebSocketException("duplicateAnnotation onMessage");
                }
                if (method.getAnnotation(OnBinary.class) != null) {
                    this.checkIsPublic(method);
                    if (binary == null) {
                        binary = method;
                        continue;
                    }
                    if (currentClazz != webSocketClazz && this.isMethodOverride(binary, method)) continue;
                    throw new WebSocketException("duplicateAnnotation OnBinary");
                }
                if (method.getAnnotation(OnEvent.class) == null) continue;
                this.checkIsPublic(method);
                if (event == null) {
                    event = method;
                    continue;
                }
                if (currentClazz != webSocketClazz && this.isMethodOverride(event, method)) continue;
                throw new WebSocketException("duplicateAnnotation OnEvent");
            }
            currentClazz = currentClazz.getSuperclass();
        }
        if (handshake != null && handshake.getDeclaringClass() != webSocketClazz && this.isOverrideWithoutAnnotation(webSocketClazzMethods, handshake, BeforeHandshake.class)) {
            handshake = null;
        }
        if (open != null && open.getDeclaringClass() != webSocketClazz && this.isOverrideWithoutAnnotation(webSocketClazzMethods, open, OnOpen.class)) {
            open = null;
        }
        if (close != null && close.getDeclaringClass() != webSocketClazz && this.isOverrideWithoutAnnotation(webSocketClazzMethods, close, OnClose.class)) {
            close = null;
        }
        if (error != null && error.getDeclaringClass() != webSocketClazz && this.isOverrideWithoutAnnotation(webSocketClazzMethods, error, OnError.class)) {
            error = null;
        }
        if (message != null && message.getDeclaringClass() != webSocketClazz && this.isOverrideWithoutAnnotation(webSocketClazzMethods, message, OnMessage.class)) {
            message = null;
        }
        if (binary != null && binary.getDeclaringClass() != webSocketClazz && this.isOverrideWithoutAnnotation(webSocketClazzMethods, binary, OnBinary.class)) {
            binary = null;
        }
        if (event != null && event.getDeclaringClass() != webSocketClazz && this.isOverrideWithoutAnnotation(webSocketClazzMethods, event, OnEvent.class)) {
            event = null;
        }
        this.beforeHandshake = handshake;
        this.onOpen = open;
        this.onClose = close;
        this.onError = error;
        this.onMessage = message;
        this.onBinary = binary;
        this.onEvent = event;
        this.beforeHandshakeParameters = WebSocketMethodMapping.getParameters(this.beforeHandshake);
        this.onOpenParameters = WebSocketMethodMapping.getParameters(this.onOpen);
        this.onCloseParameters = WebSocketMethodMapping.getParameters(this.onClose);
        this.onMessageParameters = WebSocketMethodMapping.getParameters(this.onMessage);
        this.onErrorParameters = WebSocketMethodMapping.getParameters(this.onError);
        this.onBinaryParameters = WebSocketMethodMapping.getParameters(this.onBinary);
        this.onEventParameters = WebSocketMethodMapping.getParameters(this.onEvent);
        this.beforeHandshakeArgResolvers = this.getResolvers(this.beforeHandshakeParameters);
        this.onOpenArgResolvers = this.getResolvers(this.onOpenParameters);
        this.onCloseArgResolvers = this.getResolvers(this.onCloseParameters);
        this.onMessageArgResolvers = this.getResolvers(this.onMessageParameters);
        this.onErrorArgResolvers = this.getResolvers(this.onErrorParameters);
        this.onBinaryArgResolvers = this.getResolvers(this.onBinaryParameters);
        this.onEventArgResolvers = this.getResolvers(this.onEventParameters);
    }

    private void checkIsPublic(Method m) throws WebSocketException {
        if (!Modifier.isPublic(m.getModifiers())) {
            throw new WebSocketException("methodNotPublic " + m.getName());
        }
    }

    private boolean isMethodOverride(Method method1, Method method2) {
        return method1.getName().equals(method2.getName()) && method1.getReturnType().equals(method2.getReturnType()) && Arrays.equals(method1.getParameterTypes(), method2.getParameterTypes());
    }

    private boolean isOverrideWithoutAnnotation(Method[] methods, Method superClazzMethod, Class<? extends Annotation> annotation) {
        for (Method method : methods) {
            if (!this.isMethodOverride(method, superClazzMethod) || method.getAnnotation(annotation) != null) continue;
            return true;
        }
        return false;
    }

    Object getEndpointInstance() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object implement = this.webSocketClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        AutowiredAnnotationBeanPostProcessor postProcessor = (AutowiredAnnotationBeanPostProcessor)this.applicationContext.getBean(AutowiredAnnotationBeanPostProcessor.class);
        postProcessor.postProcessProperties(null, implement, null);
        return implement;
    }

    Method getBeforeHandshake() {
        return this.beforeHandshake;
    }

    Object[] getBeforeHandshakeArgs(Channel channel, FullHttpRequest req) throws Exception {
        return this.getMethodArgumentValues(channel, req, this.beforeHandshakeParameters, this.beforeHandshakeArgResolvers);
    }

    Method getOnOpen() {
        return this.onOpen;
    }

    Object[] getOnOpenArgs(Channel channel, FullHttpRequest req) throws Exception {
        return this.getMethodArgumentValues(channel, req, this.onOpenParameters, this.onOpenArgResolvers);
    }

    MethodArgumentResolver[] getOnOpenArgResolvers() {
        return this.onOpenArgResolvers;
    }

    Method getOnClose() {
        return this.onClose;
    }

    Object[] getOnCloseArgs(Channel channel) throws Exception {
        return this.getMethodArgumentValues(channel, null, this.onCloseParameters, this.onCloseArgResolvers);
    }

    Method getOnError() {
        return this.onError;
    }

    Object[] getOnErrorArgs(Channel channel, Throwable throwable) throws Exception {
        return this.getMethodArgumentValues(channel, throwable, this.onErrorParameters, this.onErrorArgResolvers);
    }

    Method getOnMessage() {
        return this.onMessage;
    }

    Object[] getOnMessageArgs(Channel channel, TextWebSocketFrame textWebSocketFrame) throws Exception {
        return this.getMethodArgumentValues(channel, textWebSocketFrame, this.onMessageParameters, this.onMessageArgResolvers);
    }

    Method getOnBinary() {
        return this.onBinary;
    }

    Object[] getOnBinaryArgs(Channel channel, BinaryWebSocketFrame binaryWebSocketFrame) throws Exception {
        return this.getMethodArgumentValues(channel, binaryWebSocketFrame, this.onBinaryParameters, this.onBinaryArgResolvers);
    }

    Method getOnEvent() {
        return this.onEvent;
    }

    Object[] getOnEventArgs(Channel channel, Object evt) throws Exception {
        return this.getMethodArgumentValues(channel, evt, this.onEventParameters, this.onEventArgResolvers);
    }

    private Object[] getMethodArgumentValues(Channel channel, Object object, MethodParameter[] parameters, MethodArgumentResolver[] resolvers) throws Exception {
        Object[] objects = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object arg;
            MethodParameter parameter = parameters[i];
            MethodArgumentResolver resolver = resolvers[i];
            objects[i] = arg = resolver.resolveArgument(parameter, channel, object);
        }
        return objects;
    }

    private MethodArgumentResolver[] getResolvers(MethodParameter[] parameters) throws WebSocketException {
        MethodArgumentResolver[] methodArgumentResolvers = new MethodArgumentResolver[parameters.length];
        List<MethodArgumentResolver> resolvers = this.getDefaultResolvers();
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter parameter = parameters[i];
            for (MethodArgumentResolver resolver : resolvers) {
                if (!resolver.supportsParameter(parameter)) continue;
                methodArgumentResolvers[i] = resolver;
                break;
            }
            if (methodArgumentResolvers[i] != null) continue;
            throw new WebSocketException("paramClassIncorrect parameter name : " + parameter.getParameterName());
        }
        return methodArgumentResolvers;
    }

    private List<MethodArgumentResolver> getDefaultResolvers() {
        ArrayList<MethodArgumentResolver> resolvers = new ArrayList<MethodArgumentResolver>();
        resolvers.add(new SessionMethodArgumentResolver());
        resolvers.add(new HttpHeadersMethodArgumentResolver());
        resolvers.add(new TextMethodArgumentResolver());
        resolvers.add(new ThrowableMethodArgumentResolver());
        resolvers.add(new ByteMethodArgumentResolver());
        resolvers.add(new RequestParamMapMethodArgumentResolver());
        resolvers.add(new RequestParamMethodArgumentResolver(this.beanFactory));
        resolvers.add(new PathVariableMapMethodArgumentResolver());
        resolvers.add(new PathVariableMethodArgumentResolver(this.beanFactory));
        resolvers.add(new EventMethodArgumentResolver(this.beanFactory));
        return resolvers;
    }

    private static MethodParameter[] getParameters(Method method) {
        if (method == null) {
            return new MethodParameter[0];
        }
        int paramsCount = method.getParameterCount();
        MethodParameter[] result = new MethodParameter[paramsCount];
        for (int i = 0; i < paramsCount; ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i);
            methodParameter.initParameterNameDiscovery(parameterNameDiscoverer);
            result[i] = methodParameter;
        }
        return result;
    }
}

