/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.websocket.netty.standard.handler;

import cn.twelvet.websocket.netty.domain.WebSocketEndpointServer;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;

public class WebSocketServerHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private final WebSocketEndpointServer webSocketEndpointServer;

    public WebSocketServerHandler(WebSocketEndpointServer webSocketEndpointServer) {
        this.webSocketEndpointServer = webSocketEndpointServer;
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) throws Exception {
        this.handleWebSocketFrame(ctx, msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.webSocketEndpointServer.doOnError(ctx.channel(), cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.webSocketEndpointServer.doOnClose(ctx.channel());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.webSocketEndpointServer.doOnEvent(ctx.channel(), evt);
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof TextWebSocketFrame) {
            this.webSocketEndpointServer.doOnMessage(ctx.channel(), frame);
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (frame instanceof CloseWebSocketFrame) {
            ctx.writeAndFlush((Object)frame.retainedDuplicate()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        if (frame instanceof BinaryWebSocketFrame) {
            this.webSocketEndpointServer.doOnBinary(ctx.channel(), frame);
            return;
        }
        if (frame instanceof PongWebSocketFrame) {
            return;
        }
    }
}

