/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.websocket.netty.standard;

import cn.twelvet.websocket.netty.domain.WebSocketEndpointServer;
import cn.twelvet.websocket.netty.standard.WebSocketEndpointConfig;
import cn.twelvet.websocket.netty.standard.handler.HttpServerHandler;
import cn.twelvet.websocket.netty.util.SslUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import org.springframework.util.ObjectUtils;

public class WebsocketServer {
    private final WebSocketEndpointServer webSocketEndpointServer;
    private final WebSocketEndpointConfig webSocketEndpointConfig;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebsocketServer.class);

    public WebsocketServer(WebSocketEndpointServer webSocketServerHandler, WebSocketEndpointConfig webSocketEndpointConfig) {
        this.webSocketEndpointServer = webSocketServerHandler;
        this.webSocketEndpointConfig = webSocketEndpointConfig;
    }

    public void init() throws InterruptedException, SSLException {
        ChannelFuture channelFuture;
        DefaultEventExecutorGroup eventExecutorGroup = null;
        final SslContext sslCtx = !ObjectUtils.isEmpty((Object)this.webSocketEndpointConfig.getKeyStore()) ? SslUtils.createSslContext(this.webSocketEndpointConfig.getKeyPassword(), this.webSocketEndpointConfig.getKeyStore(), this.webSocketEndpointConfig.getKeyStoreType(), this.webSocketEndpointConfig.getKeyStorePassword(), this.webSocketEndpointConfig.getTrustStore(), this.webSocketEndpointConfig.getTrustStoreType(), this.webSocketEndpointConfig.getTrustStorePassword()) : null;
        final CorsConfig corsConfig = this.createCorsConfig(this.webSocketEndpointConfig.getCorsOrigins(), this.webSocketEndpointConfig.getCorsAllowCredentials());
        if (this.webSocketEndpointConfig.isUseEventExecutorGroup()) {
            eventExecutorGroup = new DefaultEventExecutorGroup(this.webSocketEndpointConfig.getEventExecutorGroupThreads() == 0 ? 16 : this.webSocketEndpointConfig.getEventExecutorGroupThreads());
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(this.webSocketEndpointConfig.getBossLoopGroupThreads());
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(this.webSocketEndpointConfig.getWorkerLoopGroupThreads());
        ServerBootstrap bootstrap = new ServerBootstrap();
        DefaultEventExecutorGroup finalEventExecutorGroup = eventExecutorGroup;
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.webSocketEndpointConfig.getConnectTimeoutMillis())).option(ChannelOption.SO_BACKLOG, (Object)this.webSocketEndpointConfig.getSoBacklog())).childOption(ChannelOption.WRITE_SPIN_COUNT, (Object)this.webSocketEndpointConfig.getWriteSpinCount()).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.webSocketEndpointConfig.getWriteBufferLowWaterMark(), this.webSocketEndpointConfig.getWriteBufferHighWaterMark())).childOption(ChannelOption.TCP_NODELAY, (Object)this.webSocketEndpointConfig.isTcpNodelay()).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.webSocketEndpointConfig.isSoKeepalive()).childOption(ChannelOption.SO_LINGER, (Object)this.webSocketEndpointConfig.getSoLinger()).childOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)this.webSocketEndpointConfig.isAllowHalfClosure()).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new ChannelInitializer<NioSocketChannel>((EventExecutorGroup)finalEventExecutorGroup){
            final /* synthetic */ EventExecutorGroup val$finalEventExecutorGroup;
            {
                this.val$finalEventExecutorGroup = eventExecutorGroup;
            }

            protected void initChannel(NioSocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                if (sslCtx != null) {
                    pipeline.addFirst(new ChannelHandler[]{sslCtx.newHandler(ch.alloc())});
                }
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                if (corsConfig != null) {
                    pipeline.addLast(new ChannelHandler[]{new CorsHandler(corsConfig)});
                }
                pipeline.addLast(new ChannelHandler[]{new HttpServerHandler(WebsocketServer.this.webSocketEndpointServer, WebsocketServer.this.webSocketEndpointConfig, this.val$finalEventExecutorGroup, corsConfig != null)});
            }
        });
        if (this.webSocketEndpointConfig.getSoRcvbuf() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.webSocketEndpointConfig.getSoRcvbuf());
        }
        if (this.webSocketEndpointConfig.getSoSndbuf() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.webSocketEndpointConfig.getSoSndbuf());
        }
        if ("0.0.0.0".equals(this.webSocketEndpointConfig.getHost())) {
            channelFuture = bootstrap.bind(this.webSocketEndpointConfig.getPort());
        } else {
            try {
                channelFuture = bootstrap.bind((SocketAddress)new InetSocketAddress(InetAddress.getByName(this.webSocketEndpointConfig.getHost()), this.webSocketEndpointConfig.getPort()));
            }
            catch (UnknownHostException e) {
                channelFuture = bootstrap.bind(this.webSocketEndpointConfig.getHost(), this.webSocketEndpointConfig.getPort());
                e.printStackTrace();
            }
        }
        channelFuture.addListener(future -> {
            if (!future.isSuccess()) {
                future.cause().printStackTrace();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> WebsocketServer.lambda$init$1((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup)));
    }

    private CorsConfig createCorsConfig(String[] corsOrigins, Boolean corsAllowCredentials) {
        if (corsOrigins.length == 0) {
            return null;
        }
        CorsConfigBuilder corsConfigBuilder = null;
        for (String corsOrigin : corsOrigins) {
            if (!"*".equals(corsOrigin)) continue;
            corsConfigBuilder = CorsConfigBuilder.forAnyOrigin();
            break;
        }
        if (corsConfigBuilder == null) {
            corsConfigBuilder = CorsConfigBuilder.forOrigins((String[])corsOrigins);
        }
        if (corsAllowCredentials != null && corsAllowCredentials.booleanValue()) {
            corsConfigBuilder.allowCredentials();
        }
        corsConfigBuilder.allowNullOrigin();
        return corsConfigBuilder.build();
    }

    public WebSocketEndpointServer getEndpointServer() {
        return this.webSocketEndpointServer;
    }

    private static /* synthetic */ void lambda$init$1(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        bossGroup.shutdownGracefully().syncUninterruptibly();
        workerGroup.shutdownGracefully().syncUninterruptibly();
    }
}

