/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.websocket.netty.standard;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.springframework.util.ObjectUtils;

public class WebSocketEndpointConfig {
    private final String host;
    private final int port;
    private final int bossLoopGroupThreads;
    private final int workerLoopGroupThreads;
    private final boolean useCompressionHandler;
    private final int connectTimeoutMillis;
    private final int soBacklog;
    private final int writeSpinCount;
    private final int writeBufferHighWaterMark;
    private final int writeBufferLowWaterMark;
    private final int soRcvbuf;
    private final int soSndbuf;
    private final boolean tcpNodelay;
    private final boolean soKeepalive;
    private final int soLinger;
    private final boolean allowHalfClosure;
    private final int readerIdleTimeSeconds;
    private final int writerIdleTimeSeconds;
    private final int allIdleTimeSeconds;
    private final int maxFramePayloadLength;
    private final boolean useEventExecutorGroup;
    private final int eventExecutorGroupThreads;
    private final String keyPassword;
    private final String keyStore;
    private final String keyStorePassword;
    private final String keyStoreType;
    private final String trustStore;
    private final String trustStorePassword;
    private final String trustStoreType;
    private final String[] corsOrigins;
    private final Boolean corsAllowCredentials;
    private static Integer randomPort;

    public WebSocketEndpointConfig(String host, int port, int bossLoopGroupThreads, int workerLoopGroupThreads, boolean useCompressionHandler, int connectTimeoutMillis, int soBacklog, int writeSpinCount, int writeBufferHighWaterMark, int writeBufferLowWaterMark, int soRcvbuf, int soSndbuf, boolean tcpNodelay, boolean soKeepalive, int soLinger, boolean allowHalfClosure, int readerIdleTimeSeconds, int writerIdleTimeSeconds, int allIdleTimeSeconds, int maxFramePayloadLength, boolean useEventExecutorGroup, int eventExecutorGroupThreads, String keyPassword, String keyStore, String keyStorePassword, String keyStoreType, String trustStore, String trustStorePassword, String trustStoreType, String[] corsOrigins, Boolean corsAllowCredentials) {
        this.host = ObjectUtils.isEmpty((Object)host) || "0.0.0.0".equals(host) || "0.0.0.0/0.0.0.0".equals(host) ? "0.0.0.0" : host;
        this.port = this.getAvailablePort(port);
        this.bossLoopGroupThreads = bossLoopGroupThreads;
        this.workerLoopGroupThreads = workerLoopGroupThreads;
        this.useCompressionHandler = useCompressionHandler;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.soBacklog = soBacklog;
        this.writeSpinCount = writeSpinCount;
        this.writeBufferHighWaterMark = writeBufferHighWaterMark;
        this.writeBufferLowWaterMark = writeBufferLowWaterMark;
        this.soRcvbuf = soRcvbuf;
        this.soSndbuf = soSndbuf;
        this.tcpNodelay = tcpNodelay;
        this.soKeepalive = soKeepalive;
        this.soLinger = soLinger;
        this.allowHalfClosure = allowHalfClosure;
        this.readerIdleTimeSeconds = readerIdleTimeSeconds;
        this.writerIdleTimeSeconds = writerIdleTimeSeconds;
        this.allIdleTimeSeconds = allIdleTimeSeconds;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.useEventExecutorGroup = useEventExecutorGroup;
        this.eventExecutorGroupThreads = eventExecutorGroupThreads;
        this.keyPassword = keyPassword;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
        this.corsOrigins = corsOrigins;
        this.corsAllowCredentials = corsAllowCredentials;
    }

    private int getAvailablePort(int port) {
        if (port != 0) {
            return port;
        }
        if (randomPort != null && randomPort != 0) {
            return randomPort;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(0);
        Socket socket = new Socket();
        try {
            socket.bind(inetSocketAddress);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int localPort = socket.getLocalPort();
        try {
            socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        randomPort = localPort;
        return localPort;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getBossLoopGroupThreads() {
        return this.bossLoopGroupThreads;
    }

    public int getWorkerLoopGroupThreads() {
        return this.workerLoopGroupThreads;
    }

    public boolean isUseCompressionHandler() {
        return this.useCompressionHandler;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getSoBacklog() {
        return this.soBacklog;
    }

    public int getWriteSpinCount() {
        return this.writeSpinCount;
    }

    public int getWriteBufferHighWaterMark() {
        return this.writeBufferHighWaterMark;
    }

    public int getWriteBufferLowWaterMark() {
        return this.writeBufferLowWaterMark;
    }

    public int getSoRcvbuf() {
        return this.soRcvbuf;
    }

    public int getSoSndbuf() {
        return this.soSndbuf;
    }

    public boolean isTcpNodelay() {
        return this.tcpNodelay;
    }

    public boolean isSoKeepalive() {
        return this.soKeepalive;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    public static Integer getRandomPort() {
        return randomPort;
    }

    public int getReaderIdleTimeSeconds() {
        return this.readerIdleTimeSeconds;
    }

    public int getWriterIdleTimeSeconds() {
        return this.writerIdleTimeSeconds;
    }

    public int getAllIdleTimeSeconds() {
        return this.allIdleTimeSeconds;
    }

    public int getMaxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public boolean isUseEventExecutorGroup() {
        return this.useEventExecutorGroup;
    }

    public int getEventExecutorGroupThreads() {
        return this.eventExecutorGroupThreads;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String[] getCorsOrigins() {
        return this.corsOrigins;
    }

    public Boolean getCorsAllowCredentials() {
        return this.corsAllowCredentials;
    }
}

