/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.websocket.netty.domain;

import cn.twelvet.websocket.netty.domain.NettySession;
import cn.twelvet.websocket.netty.domain.WebSocketMethodMapping;
import cn.twelvet.websocket.netty.standard.WebSocketEndpointConfig;
import cn.twelvet.websocket.netty.support.MethodArgumentResolver;
import cn.twelvet.websocket.netty.support.WsPathMatcher;
import cn.twelvet.websocket.netty.support.impl.PathVariableMapMethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.PathVariableMethodArgumentResolver;
import cn.twelvet.websocket.netty.support.impl.path.AntPathMatcherWrapper;
import cn.twelvet.websocket.netty.support.impl.path.DefaultPathMatcher;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.TypeMismatchException;

public class WebSocketEndpointServer {
    private static final AttributeKey<Object> WEB_SOCKET_KEY = AttributeKey.valueOf((String)"WEBSOCKET_IMPLEMENT");
    public static final AttributeKey<NettySession> SESSION_KEY = AttributeKey.valueOf((String)"WEBSOCKET_SESSION");
    private static final AttributeKey<String> PATH_KEY = AttributeKey.valueOf((String)"WEBSOCKET_PATH");
    public static final AttributeKey<Map<String, String>> URI_TEMPLATE = AttributeKey.valueOf((String)"WEBSOCKET_URI_TEMPLATE");
    public static final AttributeKey<Map<String, List<String>>> REQUEST_PARAM = AttributeKey.valueOf((String)"WEBSOCKET_REQUEST_PARAM");
    private final Map<String, WebSocketMethodMapping> pathMethodMappingMap = new HashMap<String, WebSocketMethodMapping>();
    private final WebSocketEndpointConfig config;
    private final Set<WsPathMatcher> pathMatchers = new HashSet<WsPathMatcher>();
    private static final InternalLogger log = InternalLoggerFactory.getInstance(WebSocketEndpointServer.class);

    public WebSocketEndpointServer(WebSocketMethodMapping methodMapping, WebSocketEndpointConfig config, String path) {
        this.addPathMethodMapping(path, methodMapping);
        this.config = config;
    }

    public boolean hasBeforeHandshake(Channel channel, String path) {
        WebSocketMethodMapping methodMapping = this.getWebSocketMethodMapping(path, channel);
        return methodMapping.getBeforeHandshake() != null;
    }

    public void doBeforeHandshake(Channel channel, FullHttpRequest req, String path) {
        WebSocketMethodMapping methodMapping = this.getWebSocketMethodMapping(path, channel);
        Object implement = null;
        try {
            implement = methodMapping.getEndpointInstance();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return;
        }
        channel.attr(WEB_SOCKET_KEY).set(implement);
        NettySession nettySession = new NettySession(channel);
        channel.attr(SESSION_KEY).set((Object)nettySession);
        Method beforeHandshake = methodMapping.getBeforeHandshake();
        if (beforeHandshake != null) {
            try {
                beforeHandshake.invoke(implement, methodMapping.getBeforeHandshakeArgs(channel, req));
            }
            catch (TypeMismatchException e) {
                throw e;
            }
            catch (Throwable t) {
                log.error(t);
            }
        }
    }

    public void doOnOpen(Channel channel, FullHttpRequest req, String path) {
        Method onOpenMethod;
        WebSocketMethodMapping methodMapping = this.getWebSocketMethodMapping(path, channel);
        Object implement = channel.attr(WEB_SOCKET_KEY).get();
        if (implement == null) {
            try {
                implement = methodMapping.getEndpointInstance();
                channel.attr(WEB_SOCKET_KEY).set(implement);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return;
            }
            NettySession nettySession = new NettySession(channel);
            channel.attr(SESSION_KEY).set((Object)nettySession);
        }
        if ((onOpenMethod = methodMapping.getOnOpen()) != null) {
            try {
                onOpenMethod.invoke(implement, methodMapping.getOnOpenArgs(channel, req));
            }
            catch (TypeMismatchException e) {
                throw e;
            }
            catch (Throwable t) {
                log.error(t);
            }
        }
    }

    public void doOnClose(Channel channel) {
        Attribute attrPath = channel.attr(PATH_KEY);
        WebSocketMethodMapping methodMapping = null;
        if (this.pathMethodMappingMap.size() == 1) {
            methodMapping = this.pathMethodMappingMap.values().iterator().next();
        } else {
            String path = (String)attrPath.get();
            methodMapping = this.pathMethodMappingMap.get(path);
            if (methodMapping == null) {
                return;
            }
        }
        if (methodMapping.getOnClose() != null) {
            if (!channel.hasAttr(SESSION_KEY)) {
                return;
            }
            Object implement = channel.attr(WEB_SOCKET_KEY).get();
            try {
                methodMapping.getOnClose().invoke(implement, methodMapping.getOnCloseArgs(channel));
            }
            catch (Throwable t) {
                log.error(t);
            }
        }
    }

    public void doOnError(Channel channel, Throwable throwable) {
        WebSocketMethodMapping webSocketMethodMapping = this.getWebSocketMethodMapping(channel);
        if (webSocketMethodMapping.getOnError() != null) {
            if (!channel.hasAttr(SESSION_KEY)) {
                return;
            }
            Object implement = channel.attr(WEB_SOCKET_KEY).get();
            try {
                Method method = webSocketMethodMapping.getOnError();
                Object[] args = webSocketMethodMapping.getOnErrorArgs(channel, throwable);
                method.invoke(implement, args);
            }
            catch (Throwable t) {
                log.error(t);
            }
        }
    }

    public void doOnMessage(Channel channel, WebSocketFrame frame) {
        WebSocketMethodMapping webSocketMethodMapping = this.getWebSocketMethodMapping(channel);
        if (webSocketMethodMapping.getOnMessage() != null) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            Object implement = channel.attr(WEB_SOCKET_KEY).get();
            try {
                webSocketMethodMapping.getOnMessage().invoke(implement, webSocketMethodMapping.getOnMessageArgs(channel, textFrame));
            }
            catch (Throwable t) {
                log.error(t);
            }
        }
    }

    public void doOnBinary(Channel channel, WebSocketFrame frame) {
        WebSocketMethodMapping webSocketMethodMapping = this.getWebSocketMethodMapping(channel);
        if (webSocketMethodMapping.getOnBinary() != null) {
            BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)frame;
            Object implement = channel.attr(WEB_SOCKET_KEY).get();
            try {
                webSocketMethodMapping.getOnBinary().invoke(implement, webSocketMethodMapping.getOnBinaryArgs(channel, binaryWebSocketFrame));
            }
            catch (Throwable t) {
                log.error(t);
            }
        }
    }

    public void doOnEvent(Channel channel, Object evt) {
        WebSocketMethodMapping webSocketMethodMapping = this.getWebSocketMethodMapping(channel);
        if (webSocketMethodMapping.getOnEvent() != null) {
            if (!channel.hasAttr(SESSION_KEY)) {
                return;
            }
            Object implement = channel.attr(WEB_SOCKET_KEY).get();
            try {
                webSocketMethodMapping.getOnEvent().invoke(implement, webSocketMethodMapping.getOnEventArgs(channel, evt));
            }
            catch (Throwable t) {
                log.error(t);
            }
        }
    }

    public String getHost() {
        return this.config.getHost();
    }

    public int getPort() {
        return this.config.getPort();
    }

    public Set<WsPathMatcher> getPathMatcherSet() {
        return this.pathMatchers;
    }

    public void addPathMethodMapping(String path, WebSocketMethodMapping webSocketMethodMapping) {
        this.pathMethodMappingMap.put(path, webSocketMethodMapping);
        for (MethodArgumentResolver onOpenArgResolver : webSocketMethodMapping.getOnOpenArgResolvers()) {
            if (!(onOpenArgResolver instanceof PathVariableMethodArgumentResolver) && !(onOpenArgResolver instanceof PathVariableMapMethodArgumentResolver)) continue;
            this.pathMatchers.add(new AntPathMatcherWrapper(path));
            return;
        }
        this.pathMatchers.add(new DefaultPathMatcher(path));
    }

    private WebSocketMethodMapping getWebSocketMethodMapping(Channel channel) {
        Attribute attrPath = channel.attr(PATH_KEY);
        if (this.pathMethodMappingMap.size() == 1) {
            return this.pathMethodMappingMap.values().iterator().next();
        }
        String path = (String)attrPath.get();
        return this.pathMethodMappingMap.get(path);
    }

    private WebSocketMethodMapping getWebSocketMethodMapping(String path, Channel channel) {
        WebSocketMethodMapping methodMapping;
        if (this.pathMethodMappingMap.size() == 1) {
            methodMapping = this.pathMethodMappingMap.values().iterator().next();
        } else {
            Attribute attrPath = channel.attr(PATH_KEY);
            attrPath.set((Object)path);
            methodMapping = this.pathMethodMappingMap.get(path);
            if (methodMapping == null) {
                throw new RuntimeException("path " + path + " is not in pathMethodMappingMap ");
            }
        }
        return methodMapping;
    }
}

