/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.websocket.netty.standard.handler;

import cn.twelvet.websocket.netty.domain.WebSocketEndpointServer;
import cn.twelvet.websocket.netty.standard.WebSocketEndpointConfig;
import cn.twelvet.websocket.netty.standard.handler.WebSocketServerHandler;
import cn.twelvet.websocket.netty.support.WsPathMatcher;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Set;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.ObjectUtils;

public class HttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(HttpServerHandler.class);
    private final WebSocketEndpointServer webSocketEndpointServer;
    private final WebSocketEndpointConfig webSocketEndpointConfig;
    private final EventExecutorGroup eventExecutorGroup;
    private final boolean isCors;
    private static ByteBuf faviconByteBuf = null;
    private static ByteBuf notFoundByteBuf = null;
    private static ByteBuf badRequestByteBuf = null;
    private static ByteBuf forbiddenByteBuf = null;
    private static ByteBuf internalServerErrorByteBuf = null;

    private static ByteBuf buildStaticRes(String resPath) {
        try {
            int available;
            InputStream inputStream = HttpServerHandler.class.getResourceAsStream(resPath);
            if (inputStream != null && (available = inputStream.available()) != 0) {
                byte[] bytes = new byte[available];
                inputStream.read(bytes);
                return ByteBufAllocator.DEFAULT.buffer(bytes.length).writeBytes(bytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public HttpServerHandler(WebSocketEndpointServer webSocketEndpointServer, WebSocketEndpointConfig webSocketEndpointConfig, EventExecutorGroup eventExecutorGroup, boolean isCors) {
        this.webSocketEndpointServer = webSocketEndpointServer;
        this.webSocketEndpointConfig = webSocketEndpointConfig;
        this.eventExecutorGroup = eventExecutorGroup;
        this.isCors = isCors;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        try {
            this.handleHttpRequest(ctx, msg);
        }
        catch (TypeMismatchException e) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
            HttpServerHandler.sendHttpResponse(ctx, msg, (FullHttpResponse)res);
            log.error((Throwable)e);
        }
        catch (Exception e) {
            DefaultFullHttpResponse res = internalServerErrorByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, internalServerErrorByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            HttpServerHandler.sendHttpResponse(ctx, msg, (FullHttpResponse)res);
            log.error((Throwable)e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.webSocketEndpointServer.doOnError(ctx.channel(), cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.webSocketEndpointServer.doOnClose(ctx.channel());
        super.channelInactive(ctx);
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
        WebSocketServerHandshakerFactory wsFactory;
        WebSocketServerHandshaker webSocketServerHandshaker;
        if (!req.decoderResult().isSuccess()) {
            DefaultFullHttpResponse res = badRequestByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, badRequestByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        if (req.method() != HttpMethod.GET) {
            DefaultFullHttpResponse res = forbiddenByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, forbiddenByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        HttpHeaders headers = req.headers();
        String host = headers.get((CharSequence)HttpHeaderNames.HOST);
        if (ObjectUtils.isEmpty((Object)host)) {
            DefaultFullHttpResponse res = forbiddenByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, forbiddenByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        if (!(ObjectUtils.isEmpty((Object)this.webSocketEndpointServer.getHost()) || this.webSocketEndpointServer.getHost().equals("0.0.0.0") || this.webSocketEndpointServer.getHost().equals(host.split(":")[0]))) {
            DefaultFullHttpResponse res = forbiddenByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, forbiddenByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
        String path = decoder.path();
        if ("/favicon.ico".equals(path)) {
            DefaultFullHttpResponse res = faviconByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, faviconByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        Channel channel = ctx.channel();
        String pattern = null;
        Set<WsPathMatcher> pathMatcherSet = this.webSocketEndpointServer.getPathMatcherSet();
        for (WsPathMatcher pathMatcher : pathMatcherSet) {
            if (!pathMatcher.matchAndExtract(decoder, channel)) continue;
            pattern = pathMatcher.getPattern();
            break;
        }
        if (pattern == null) {
            DefaultFullHttpResponse res = notFoundByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND, notFoundByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        if (!(req.headers().contains((CharSequence)HttpHeaderNames.UPGRADE) && req.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY) && req.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION))) {
            DefaultFullHttpResponse res = forbiddenByteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, forbiddenByteBuf.retainedDuplicate()) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        String subprotocols = null;
        if (this.webSocketEndpointServer.hasBeforeHandshake(channel, pattern)) {
            this.webSocketEndpointServer.doBeforeHandshake(channel, req, pattern);
            if (!channel.isActive()) {
                return;
            }
            AttributeKey subprotocolsAttrKey = AttributeKey.valueOf((String)"subprotocols");
            if (channel.hasAttr(subprotocolsAttrKey)) {
                subprotocols = (String)ctx.channel().attr(subprotocolsAttrKey).get();
            }
        }
        if ((webSocketServerHandshaker = (wsFactory = new WebSocketServerHandshakerFactory(HttpServerHandler.getWebSocketLocation(req), subprotocols, true, this.webSocketEndpointConfig.getMaxFramePayloadLength())).newHandshaker((HttpRequest)req)) == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)channel);
        } else {
            ChannelPipeline pipeline = ctx.pipeline();
            pipeline.remove(ctx.name());
            if (this.webSocketEndpointConfig.getReaderIdleTimeSeconds() != 0 || this.webSocketEndpointConfig.getWriterIdleTimeSeconds() != 0 || this.webSocketEndpointConfig.getAllIdleTimeSeconds() != 0) {
                pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(this.webSocketEndpointConfig.getReaderIdleTimeSeconds(), this.webSocketEndpointConfig.getWriterIdleTimeSeconds(), this.webSocketEndpointConfig.getAllIdleTimeSeconds())});
            }
            if (this.webSocketEndpointConfig.isUseCompressionHandler()) {
                pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
            }
            pipeline.addLast(new ChannelHandler[]{new WebSocketFrameAggregator(Integer.MAX_VALUE)});
            if (this.webSocketEndpointConfig.isUseEventExecutorGroup()) {
                pipeline.addLast(this.eventExecutorGroup, new ChannelHandler[]{new WebSocketServerHandler(this.webSocketEndpointServer)});
            } else {
                pipeline.addLast(new ChannelHandler[]{new WebSocketServerHandler(this.webSocketEndpointServer)});
            }
            String finalPattern = pattern;
            webSocketServerHandshaker.handshake(channel, req).addListener(future -> {
                if (future.isSuccess()) {
                    if (this.isCors) {
                        pipeline.remove(CorsHandler.class);
                    }
                    this.webSocketEndpointServer.doOnOpen(channel, req, finalPattern);
                } else {
                    webSocketServerHandshaker.close(channel, new CloseWebSocketFrame());
                }
            });
        }
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        int statusCode = res.status().code();
        if (statusCode != HttpResponseStatus.OK.code() && res.content().readableBytes() == 0) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
        }
        HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)req) || statusCode != HttpResponseStatus.OK.code()) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static String getWebSocketLocation(FullHttpRequest req) {
        String location = req.headers().get((CharSequence)HttpHeaderNames.HOST) + req.uri();
        return "ws://" + location;
    }

    static {
        faviconByteBuf = HttpServerHandler.buildStaticRes("/favicon.ico");
        notFoundByteBuf = HttpServerHandler.buildStaticRes("/public/error/404.html");
        badRequestByteBuf = HttpServerHandler.buildStaticRes("/public/error/400.html");
        forbiddenByteBuf = HttpServerHandler.buildStaticRes("/public/error/403.html");
        internalServerErrorByteBuf = HttpServerHandler.buildStaticRes("/public/error/500.html");
        if (notFoundByteBuf == null) {
            notFoundByteBuf = HttpServerHandler.buildStaticRes("/public/error/4xx.html");
        }
        if (badRequestByteBuf == null) {
            badRequestByteBuf = HttpServerHandler.buildStaticRes("/public/error/4xx.html");
        }
        if (forbiddenByteBuf == null) {
            forbiddenByteBuf = HttpServerHandler.buildStaticRes("/public/error/4xx.html");
        }
        if (internalServerErrorByteBuf == null) {
            internalServerErrorByteBuf = HttpServerHandler.buildStaticRes("/public/error/5xx.html");
        }
    }
}

