/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.websocket.netty.standard;

import cn.twelvet.websocket.netty.annotation.WebSocketEndpoint;
import cn.twelvet.websocket.netty.autoconfigure.annotation.EnableWebSocket;
import cn.twelvet.websocket.netty.domain.WebSocketEndpointServer;
import cn.twelvet.websocket.netty.domain.WebSocketMethodMapping;
import cn.twelvet.websocket.netty.exception.WebSocketException;
import cn.twelvet.websocket.netty.standard.EndpointClassPathScanner;
import cn.twelvet.websocket.netty.standard.WebSocketEndpointConfig;
import cn.twelvet.websocket.netty.standard.WebsocketServer;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.net.ssl.SSLException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class WebSocketEndpointExporter
extends ApplicationObjectSupport
implements SmartInitializingSingleton,
BeanFactoryAware {
    private final ResourceLoader resourceLoader;
    private AbstractBeanFactory beanFactory;
    private final Map<InetSocketAddress, WebsocketServer> addressWebsocketServerMap = new HashMap<InetSocketAddress, WebsocketServer>();

    public WebSocketEndpointExporter(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof AbstractBeanFactory)) {
            throw new IllegalArgumentException("AutowiredAnnotationBeanPostProcessor requires a AbstractBeanFactory: " + beanFactory);
        }
        this.beanFactory = (AbstractBeanFactory)beanFactory;
    }

    public void afterSingletonsInstantiated() {
        this.registerEndpoints();
    }

    protected void registerEndpoints() {
        String[] endpointBeanNames;
        ApplicationContext applicationContext = this.getApplicationContext();
        assert (applicationContext != null);
        this.scanPackage(applicationContext);
        for (String beanName : endpointBeanNames = applicationContext.getBeanNamesForAnnotation(WebSocketEndpoint.class)) {
            Class endpointClass = applicationContext.getType(beanName);
            assert (endpointClass != null);
            String name = endpointClass.getName();
            if (name.contains("$$")) {
                this.registerEndpoint(endpointClass.getSuperclass());
                continue;
            }
            this.registerEndpoint(endpointClass);
        }
        this.init();
    }

    private void scanPackage(ApplicationContext applicationContext) {
        String[] basePackages = null;
        Map enableWebSocketBeans = applicationContext.getBeansWithAnnotation(EnableWebSocket.class);
        for (Object value : enableWebSocketBeans.values()) {
            EnableWebSocket enableWebSocket = (EnableWebSocket)AnnotationUtils.findAnnotation(value.getClass(), EnableWebSocket.class);
            assert (enableWebSocket != null);
            if (enableWebSocket.scanBasePackages().length == 0) continue;
            basePackages = enableWebSocket.scanBasePackages();
            break;
        }
        if (basePackages == null) {
            String[] springBootApplicationBeanName = applicationContext.getBeanNamesForAnnotation(SpringBootApplication.class);
            Object springBootApplicationBean = applicationContext.getBean(springBootApplicationBeanName[0]);
            SpringBootApplication springBootApplication = (SpringBootApplication)AnnotationUtils.findAnnotation(springBootApplicationBean.getClass(), SpringBootApplication.class);
            assert (springBootApplication != null);
            if (springBootApplication.scanBasePackages().length != 0) {
                basePackages = springBootApplication.scanBasePackages();
            } else {
                String packageName = ClassUtils.getPackageName((String)springBootApplicationBean.getClass().getName());
                basePackages = new String[]{packageName};
            }
        }
        EndpointClassPathScanner scanHandle = new EndpointClassPathScanner((BeanDefinitionRegistry)applicationContext, false);
        if (this.resourceLoader != null) {
            scanHandle.setResourceLoader(this.resourceLoader);
        }
        for (String basePackage : basePackages) {
            scanHandle.doScan(basePackage);
        }
    }

    private void init() {
        for (Map.Entry<InetSocketAddress, WebsocketServer> entry : this.addressWebsocketServerMap.entrySet()) {
            WebsocketServer websocketServer = entry.getValue();
            try {
                websocketServer.init();
                WebSocketEndpointServer webSocketEndpointServer = websocketServer.getEndpointServer();
                StringJoiner stringJoiner = new StringJoiner(",");
                webSocketEndpointServer.getPathMatcherSet().forEach(pathMatcher -> stringJoiner.add("'" + pathMatcher.getPattern() + "'"));
                this.logger.info((Object)String.format("\u001b[34mNetty WebSocket started on port: %s with context path(s): %s .\u001b[0m", webSocketEndpointServer.getPort(), stringJoiner));
            }
            catch (InterruptedException e) {
                this.logger.error((Object)String.format("websocket [%s] init fail", entry.getKey()), (Throwable)e);
            }
            catch (SSLException e) {
                this.logger.error((Object)String.format("websocket [%s] ssl create fail", entry.getKey()), (Throwable)e);
            }
        }
    }

    private void registerEndpoint(Class<?> endpointClass) {
        WebSocketMethodMapping webSocketMethodMapping;
        WebSocketEndpoint annotation = (WebSocketEndpoint)AnnotatedElementUtils.findMergedAnnotation(endpointClass, WebSocketEndpoint.class);
        if (annotation == null) {
            throw new IllegalStateException("missingAnnotation WebSocketEndpoint");
        }
        WebSocketEndpointConfig webSocketEndpointConfig = this.buildWebSocketConfig(annotation);
        ApplicationContext context = this.getApplicationContext();
        try {
            webSocketMethodMapping = new WebSocketMethodMapping(endpointClass, context, this.beanFactory);
        }
        catch (WebSocketException e) {
            throw new IllegalStateException("Failed to register WebSocketEndpointConfig: " + webSocketEndpointConfig, e);
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(webSocketEndpointConfig.getHost(), webSocketEndpointConfig.getPort());
        String path = this.resolveAnnotationValue(annotation.value(), String.class, "path");
        WebsocketServer websocketServer = this.addressWebsocketServerMap.get(inetSocketAddress);
        if (websocketServer == null) {
            WebSocketEndpointServer webSocketEndpointServer = new WebSocketEndpointServer(webSocketMethodMapping, webSocketEndpointConfig, path);
            websocketServer = new WebsocketServer(webSocketEndpointServer, webSocketEndpointConfig);
            this.addressWebsocketServerMap.put(inetSocketAddress, websocketServer);
        } else {
            websocketServer.getEndpointServer().addPathMethodMapping(path, webSocketMethodMapping);
        }
    }

    private WebSocketEndpointConfig buildWebSocketConfig(WebSocketEndpoint annotation) {
        String host = this.resolveAnnotationValue(annotation.host(), String.class, "host");
        int port = this.resolveAnnotationValue(annotation.port(), Integer.class, "port");
        int bossLoopGroupThreads = this.resolveAnnotationValue(annotation.bossLoopGroupThreads(), Integer.class, "bossLoopGroupThreads");
        int workerLoopGroupThreads = this.resolveAnnotationValue(annotation.workerLoopGroupThreads(), Integer.class, "workerLoopGroupThreads");
        boolean useCompressionHandler = this.resolveAnnotationValue(annotation.useCompressionHandler(), Boolean.class, "useCompressionHandler");
        int optionConnectTimeoutMillis = this.resolveAnnotationValue(annotation.optionConnectTimeoutMillis(), Integer.class, "optionConnectTimeoutMillis");
        int optionSoBacklog = this.resolveAnnotationValue(annotation.optionSoBacklog(), Integer.class, "optionSoBacklog");
        int childOptionWriteSpinCount = this.resolveAnnotationValue(annotation.childOptionWriteSpinCount(), Integer.class, "childOptionWriteSpinCount");
        int childOptionWriteBufferHighWaterMark = this.resolveAnnotationValue(annotation.childOptionWriteBufferHighWaterMark(), Integer.class, "childOptionWriteBufferHighWaterMark");
        int childOptionWriteBufferLowWaterMark = this.resolveAnnotationValue(annotation.childOptionWriteBufferLowWaterMark(), Integer.class, "childOptionWriteBufferLowWaterMark");
        int childOptionSoRcvbuf = this.resolveAnnotationValue(annotation.childOptionSoRcvbuf(), Integer.class, "childOptionSoRcvbuf");
        int childOptionSoSndbuf = this.resolveAnnotationValue(annotation.childOptionSoSndbuf(), Integer.class, "childOptionSoSndbuf");
        boolean childOptionTcpNodelay = this.resolveAnnotationValue(annotation.childOptionTcpNodelay(), Boolean.class, "childOptionTcpNodelay");
        boolean childOptionSoKeepalive = this.resolveAnnotationValue(annotation.childOptionSoKeepalive(), Boolean.class, "childOptionSoKeepalive");
        int childOptionSoLinger = this.resolveAnnotationValue(annotation.childOptionSoLinger(), Integer.class, "childOptionSoLinger");
        boolean childOptionAllowHalfClosure = this.resolveAnnotationValue(annotation.childOptionAllowHalfClosure(), Boolean.class, "childOptionAllowHalfClosure");
        int readerIdleTimeSeconds = this.resolveAnnotationValue(annotation.readerIdleTimeSeconds(), Integer.class, "readerIdleTimeSeconds");
        int writerIdleTimeSeconds = this.resolveAnnotationValue(annotation.writerIdleTimeSeconds(), Integer.class, "writerIdleTimeSeconds");
        int allIdleTimeSeconds = this.resolveAnnotationValue(annotation.allIdleTimeSeconds(), Integer.class, "allIdleTimeSeconds");
        int maxFramePayloadLength = this.resolveAnnotationValue(annotation.maxFramePayloadLength(), Integer.class, "maxFramePayloadLength");
        boolean useEventExecutorGroup = this.resolveAnnotationValue(annotation.useEventExecutorGroup(), Boolean.class, "useEventExecutorGroup");
        int eventExecutorGroupThreads = this.resolveAnnotationValue(annotation.eventExecutorGroupThreads(), Integer.class, "eventExecutorGroupThreads");
        String sslKeyPassword = this.resolveAnnotationValue(annotation.sslKeyPassword(), String.class, "sslKeyPassword");
        String sslKeyStore = this.resolveAnnotationValue(annotation.sslKeyStore(), String.class, "sslKeyStore");
        String sslKeyStorePassword = this.resolveAnnotationValue(annotation.sslKeyStorePassword(), String.class, "sslKeyStorePassword");
        String sslKeyStoreType = this.resolveAnnotationValue(annotation.sslKeyStoreType(), String.class, "sslKeyStoreType");
        String sslTrustStore = this.resolveAnnotationValue(annotation.sslTrustStore(), String.class, "sslTrustStore");
        String sslTrustStorePassword = this.resolveAnnotationValue(annotation.sslTrustStorePassword(), String.class, "sslTrustStorePassword");
        String sslTrustStoreType = this.resolveAnnotationValue(annotation.sslTrustStoreType(), String.class, "sslTrustStoreType");
        Boolean corsAllowCredentials = this.resolveAnnotationValue(annotation.corsAllowCredentials(), Boolean.class, "corsAllowCredentials");
        String[] corsOrigins = annotation.corsOrigins();
        if (corsOrigins.length != 0) {
            for (int i = 0; i < corsOrigins.length; ++i) {
                corsOrigins[i] = this.resolveAnnotationValue(corsOrigins[i], String.class, "corsOrigins");
            }
        }
        return new WebSocketEndpointConfig(host, port, bossLoopGroupThreads, workerLoopGroupThreads, useCompressionHandler, optionConnectTimeoutMillis, optionSoBacklog, childOptionWriteSpinCount, childOptionWriteBufferHighWaterMark, childOptionWriteBufferLowWaterMark, childOptionSoRcvbuf, childOptionSoSndbuf, childOptionTcpNodelay, childOptionSoKeepalive, childOptionSoLinger, childOptionAllowHalfClosure, readerIdleTimeSeconds, writerIdleTimeSeconds, allIdleTimeSeconds, maxFramePayloadLength, useEventExecutorGroup, eventExecutorGroupThreads, sslKeyPassword, sslKeyStore, sslKeyStorePassword, sslKeyStoreType, sslTrustStore, sslTrustStorePassword, sslTrustStoreType, corsOrigins, corsAllowCredentials);
    }

    private <T> T resolveAnnotationValue(Object value, Class<T> requiredType, String paramName) {
        if (value instanceof String) {
            String strVal = this.beanFactory.resolveEmbeddedValue((String)value);
            BeanExpressionResolver beanExpressionResolver = this.beanFactory.getBeanExpressionResolver();
            value = beanExpressionResolver != null ? beanExpressionResolver.evaluate(strVal, new BeanExpressionContext((ConfigurableBeanFactory)this.beanFactory, null)) : strVal;
        }
        try {
            TypeConverter typeConverter = this.beanFactory.getTypeConverter();
            return (T)typeConverter.convertIfNecessary(value, requiredType);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException("Failed to convert value of parameter '" + paramName + "' to required type '" + requiredType.getName() + "'");
        }
    }
}

