/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.oss.service;

import cn.twelvet.oss.config.properties.OssProperties;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.InitializingBean;

public class OssTemplate
implements InitializingBean {
    private final OssProperties ossProperties;
    private AmazonS3 amazonS3;

    public OssTemplate(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }

    public void createBucket(String string) {
        if (!this.amazonS3.doesBucketExistV2(string)) {
            this.amazonS3.createBucket(string);
        }
    }

    public List<Bucket> getAllBuckets() {
        return this.amazonS3.listBuckets();
    }

    public Optional<Bucket> getBucket(String string) {
        return this.amazonS3.listBuckets().stream().filter(bucket -> bucket.getName().equals(string)).findFirst();
    }

    public void removeBucket(String string) {
        this.amazonS3.deleteBucket(string);
    }

    public List<S3ObjectSummary> getAllObjectsByPrefix(String string, String string2) {
        ObjectListing objectListing = this.amazonS3.listObjects(string, string2);
        return new ArrayList<S3ObjectSummary>(objectListing.getObjectSummaries());
    }

    public String getObjectURL(String string, String string2, int n) {
        return this.getObjectURL(string, string2, Duration.ofMinutes(n));
    }

    public String getObjectURL(String string, String string2, Duration duration) {
        return this.getObjectURL(string, string2, duration, HttpMethod.GET);
    }

    public String getPutObjectURL(String string, String string2, int n) {
        return this.getPutObjectURL(string, string2, Duration.ofMinutes(n));
    }

    public String getPutObjectURL(String string, String string2, Duration duration) {
        return this.getObjectURL(string, string2, duration, HttpMethod.PUT);
    }

    public String getObjectURL(String string, String string2, int n, HttpMethod httpMethod) {
        return this.getObjectURL(string, string2, Duration.ofMinutes(n), httpMethod);
    }

    public String getObjectURL(String string, String string2, Duration duration, HttpMethod httpMethod) {
        Date date = Date.from(Instant.now().plus(duration));
        URL uRL = this.amazonS3.generatePresignedUrl(new GeneratePresignedUrlRequest(string, string2).withMethod(httpMethod).withExpiration(date));
        return uRL.toString();
    }

    public String getObjectURL(String string, String string2) {
        URL uRL = this.amazonS3.getUrl(string, string2);
        return uRL.toString();
    }

    public S3Object getObject(String string, String string2) {
        return this.amazonS3.getObject(string, string2);
    }

    public void putObject(String string, String string2, InputStream inputStream) throws IOException {
        this.putObject(string, string2, inputStream, inputStream.available(), "application/octet-stream");
    }

    public void putObject(String string, String string2, String string3, InputStream inputStream) throws IOException {
        this.putObject(string, string2, inputStream, inputStream.available(), string3);
    }

    public PutObjectResult putObject(String string, String string2, InputStream inputStream, long l, String string3) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(l);
        objectMetadata.setContentType(string3);
        PutObjectRequest putObjectRequest = new PutObjectRequest(string, string2, inputStream, objectMetadata);
        putObjectRequest.getRequestClientOptions().setReadLimit(Long.valueOf(l).intValue() + 1);
        return this.amazonS3.putObject(putObjectRequest);
    }

    public S3Object getObjectInfo(String string, String string2) {
        return this.amazonS3.getObject(string, string2);
    }

    public void removeObject(String string, String string2) {
        this.amazonS3.deleteObject(string, string2);
    }

    public void afterPropertiesSet() throws Exception {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(this.ossProperties.getEndpoint(), this.ossProperties.getRegion());
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(this.ossProperties.getAccessKey(), this.ossProperties.getSecretKey());
        AWSStaticCredentialsProvider aWSStaticCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials);
        this.amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfiguration)).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)aWSStaticCredentialsProvider)).disableChunkedEncoding()).withPathStyleAccessEnabled(this.ossProperties.getPathStyleAccess())).build();
    }
}

