/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.oss.http;

import cn.twelvet.oss.service.OssTemplate;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Validated
@RestController
@RequestMapping(value={"${oss.http.prefix:}/oss"})
public class OssEndpoint {
    private final OssTemplate ossTemplate;

    public OssEndpoint(OssTemplate ossTemplate) {
        this.ossTemplate = ossTemplate;
    }

    @PostMapping(value={"/bucket/{bucketName}"})
    public Bucket createBucket(@PathVariable @NotBlank String string) {
        this.ossTemplate.createBucket(string);
        return this.ossTemplate.getBucket(string).get();
    }

    @GetMapping(value={"/bucket"})
    public List<Bucket> getBuckets() {
        return this.ossTemplate.getAllBuckets();
    }

    @GetMapping(value={"/bucket/{bucketName}"})
    public Bucket getBucket(@PathVariable @NotBlank String string) {
        return this.ossTemplate.getBucket(string).orElseThrow(() -> new IllegalArgumentException("Bucket Name not found!"));
    }

    @DeleteMapping(value={"/bucket/{bucketName}"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteBucket(@PathVariable @NotBlank String string) {
        this.ossTemplate.removeBucket(string);
    }

    @PostMapping(value={"/object/{bucketName}"})
    public S3ObjectSummary createObject(@RequestBody @NotNull MultipartFile multipartFile, @PathVariable @NotBlank String string) throws IOException {
        InputStream inputStream = multipartFile.getInputStream();
        String string2 = multipartFile.getOriginalFilename();
        this.ossTemplate.putObject(string, string2, inputStream, multipartFile.getSize(), multipartFile.getContentType());
        S3Object s3Object = this.ossTemplate.getObjectInfo(string, string2);
        ObjectMetadata objectMetadata = s3Object.getObjectMetadata();
        S3ObjectSummary s3ObjectSummary = new S3ObjectSummary();
        s3ObjectSummary.setKey(s3Object.getKey());
        s3ObjectSummary.setBucketName(string);
        s3ObjectSummary.setETag(objectMetadata.getETag());
        s3ObjectSummary.setLastModified(objectMetadata.getLastModified());
        s3ObjectSummary.setSize(objectMetadata.getContentLength());
        return s3ObjectSummary;
    }

    @PostMapping(value={"/object/{bucketName}/{objectName}"})
    public S3ObjectSummary createObject(@RequestBody @NotNull MultipartFile multipartFile, @PathVariable @NotBlank String string, @PathVariable @NotBlank String string2) throws IOException {
        InputStream inputStream = multipartFile.getInputStream();
        this.ossTemplate.putObject(string, string2, inputStream, multipartFile.getSize(), multipartFile.getContentType());
        S3Object s3Object = this.ossTemplate.getObjectInfo(string, string2);
        ObjectMetadata objectMetadata = s3Object.getObjectMetadata();
        S3ObjectSummary s3ObjectSummary = new S3ObjectSummary();
        s3ObjectSummary.setKey(s3Object.getKey());
        s3ObjectSummary.setBucketName(string);
        s3ObjectSummary.setETag(objectMetadata.getETag());
        s3ObjectSummary.setLastModified(objectMetadata.getLastModified());
        s3ObjectSummary.setSize(objectMetadata.getContentLength());
        return s3ObjectSummary;
    }

    @GetMapping(value={"/object/{bucketName}/{objectName}"})
    public List<S3ObjectSummary> filterObject(@PathVariable @NotBlank String string, @PathVariable @NotBlank String string2) {
        return this.ossTemplate.getAllObjectsByPrefix(string, string2);
    }

    @GetMapping(value={"/object/{bucketName}/{objectName}/{expires}"})
    public Map<String, Object> getObjectUrl(@PathVariable @NotBlank String string, @PathVariable @NotBlank String string2, @PathVariable @NotNull Integer n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
        hashMap.put("bucket", string);
        hashMap.put("object", string2);
        hashMap.put("url", this.ossTemplate.getObjectURL(string, string2, n));
        hashMap.put("expires", n);
        return hashMap;
    }

    @GetMapping(value={"/object/put/{bucketName}/{objectName}/{expires}"})
    public Map<String, Object> getPutObjectUrl(@PathVariable @NotBlank String string, @PathVariable @NotBlank String string2, @PathVariable @NotNull Integer n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
        hashMap.put("bucket", string);
        hashMap.put("object", string2);
        hashMap.put("url", this.ossTemplate.getPutObjectURL(string, string2, n));
        hashMap.put("expires", n);
        return hashMap;
    }

    @ResponseStatus(value=HttpStatus.ACCEPTED)
    @DeleteMapping(value={"/object/{bucketName}/{objectName}/"})
    public void deleteObject(@PathVariable @NotBlank String string, @PathVariable @NotBlank String string2) {
        this.ossTemplate.removeObject(string, string2);
    }
}

