/*
 * Decompiled with CFR 0.152.
 */
package cn.twelvet.oss;

import cn.twelvet.oss.config.properties.OssProperties;
import cn.twelvet.oss.http.OssEndpoint;
import cn.twelvet.oss.service.OssTemplate;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.web.bind.annotation.RestController;

@AutoConfiguration
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OssProperties.class})
@ComponentScan(basePackages={"cn.twelvet.oss.http"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={RestController.class})})
public class OssAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OssTemplate.class})
    @ConditionalOnProperty(prefix="oss", name={"enable"}, havingValue="true", matchIfMissing=true)
    public OssTemplate ossTemplate(OssProperties ossProperties) {
        return new OssTemplate(ossProperties);
    }

    @Bean
    @ConditionalOnWebApplication
    @ConditionalOnProperty(prefix="oss", name={"http.enable"}, havingValue="true")
    public OssEndpoint ossEndpoint(OssTemplate ossTemplate) {
        return new OssEndpoint(ossTemplate);
    }
}

