package cn.twelvet.oss.config.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * oss 配置信息 bucket 设置公共读权限 配置文件添加： oss: enable: true endpoint: http://127.0.0.1:9000 #
 * pathStyleAccess 采用nginx反向代理或者AWS S3 配置成true，支持第三方云存储配置成false pathStyleAccess: false
 * access-key: twelvet secret-key: twelvet bucket-name: twelvet region: custom-domain:
 * https://oss.xxx.com/twelvet
 *
 * @author twelvet
 */
@ConfigurationProperties(prefix = OssProperties.PREFIX)
public class OssProperties {

	/**
	 * 配置前缀
	 */
	public static final String PREFIX = "oss";

	/**
	 * 是否启用 oss，默认为：true
	 */
	private boolean enable = true;

	/**
	 * 对象存储服务的URL
	 */
	private String endpoint;

	/**
	 * true path-style nginx 反向代理和S3默认支持 pathStyle {http://endpoint/bucketname} false
	 * supports virtual-hosted-style 阿里云等需要配置为 virtual-hosted-style
	 * 模式{http://bucketname.endpoint}
	 */
	private Boolean pathStyleAccess = true;

	/**
	 * 区域
	 */
	private String region;

	/**
	 * Access key就像用户ID，可以唯一标识你的账户
	 */
	private String accessKey;

	/**
	 * Secret key是你账户的密码
	 */
	private String secretKey;

	/**
	 * 默认的存储桶名称
	 */
	private String bucketName;

	/**
	 * isEnable
	 * @return boolean
	 */
	public boolean isEnable() {
		return enable;
	}

	/**
	 * setEnable
	 * @param enable boolean
	 */
	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	/**
	 * getEndpoint
	 * @return String
	 */
	public String getEndpoint() {
		return endpoint;
	}

	/**
	 * setEndpoint
	 * @param endpoint String
	 */
	public void setEndpoint(String endpoint) {
		this.endpoint = endpoint;
	}

	/**
	 * getPathStyleAccess
	 * @return Boolean
	 */
	public Boolean getPathStyleAccess() {
		return pathStyleAccess;
	}

	/**
	 * Boolean
	 * @param pathStyleAccess Boolean
	 */
	public void setPathStyleAccess(Boolean pathStyleAccess) {
		this.pathStyleAccess = pathStyleAccess;
	}

	/**
	 * getRegion
	 * @return String
	 */
	public String getRegion() {
		return region;
	}

	/**
	 * setRegion
	 * @param region String
	 */
	public void setRegion(String region) {
		this.region = region;
	}

	/**
	 * getAccessKey
	 * @return String
	 */
	public String getAccessKey() {
		return accessKey;
	}

	/**
	 * setAccessKey
	 * @param accessKey String
	 */
	public void setAccessKey(String accessKey) {
		this.accessKey = accessKey;
	}

	/**
	 * getSecretKey
	 * @return String
	 */
	public String getSecretKey() {
		return secretKey;
	}

	/**
	 * setSecretKey
	 * @param secretKey secretKey
	 */
	public void setSecretKey(String secretKey) {
		this.secretKey = secretKey;
	}

	/**
	 * getBucketName
	 * @return String
	 */
	public String getBucketName() {
		return bucketName;
	}

	/**
	 * setBucketName
	 * @param bucketName bucketName
	 */
	public void setBucketName(String bucketName) {
		this.bucketName = bucketName;
	}

}
