package cn.twelvet.multilevel.cache.support;

import cn.twelvet.multilevel.cache.properties.CacheConfigProperties;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * 通过redis key生成serverId
 *
 * @author FlyInWind
 */
public class RedisSequenceServerIdGenerator implements ServerIdGenerator {

	/**
	 * RedisTemplate Object, Object
	 */
	protected final RedisTemplate<Object, Object> stringKeyRedisTemplate;

	/**
	 *
	 */
	protected final CacheConfigProperties properties;

	/**
	 * RedisSequenceServerIdGenerator
	 * @param stringKeyRedisTemplate RedisTemplate Object, Object
	 * @param properties CacheConfigProperties
	 */
	public RedisSequenceServerIdGenerator(RedisTemplate<Object, Object> stringKeyRedisTemplate,
			CacheConfigProperties properties) {
		this.stringKeyRedisTemplate = stringKeyRedisTemplate;
		this.properties = properties;
	}

	@Override
	public Object get() {
		return stringKeyRedisTemplate.opsForValue().increment(properties.getRedis().getServerIdGeneratorKey());
	}

}
