package cn.twelvet.multilevel.cache.support;

import cn.twelvet.multilevel.cache.enums.CacheOperation;

import java.io.Serializable;

/**
 * @author twelvet
 * @version 1.0.0
 */
public class CacheMessage implements Serializable {

	/**
	 * Object
	 */
	private Object serverId;

	/**
	 * String
	 */
	private String cacheName;

	/**
	 * CacheOperation
	 */
	private CacheOperation operation;

	/**
	 * Object
	 */
	private Object key;

	/**
	 * CacheMessage
	 * @param serverId Object
	 * @param cacheName String
	 * @param operation CacheOperation
	 * @param key Object
	 */
	public CacheMessage(Object serverId, String cacheName, CacheOperation operation, Object key) {
		this.serverId = serverId;
		this.cacheName = cacheName;
		this.operation = operation;
		this.key = key;
	}

	/**
	 * getServerId
	 * @return Object
	 */
	public Object getServerId() {
		return serverId;
	}

	/**
	 * setServerId
	 * @param serverId Object
	 */
	public void setServerId(Object serverId) {
		this.serverId = serverId;
	}

	/**
	 * getCacheName
	 * @return String
	 */
	public String getCacheName() {
		return cacheName;
	}

	/**
	 * setCacheName
	 * @param cacheName String
	 */
	public void setCacheName(String cacheName) {
		this.cacheName = cacheName;
	}

	/**
	 * getOperation
	 * @return CacheOperation
	 */
	public CacheOperation getOperation() {
		return operation;
	}

	/**
	 * setOperation
	 * @param operation CacheOperation
	 */
	public void setOperation(CacheOperation operation) {
		this.operation = operation;
	}

	/**
	 * getKey
	 * @return Object
	 */
	public Object getKey() {
		return key;
	}

	/**
	 * setKey
	 * @param key Object
	 */
	public void setKey(Object key) {
		this.key = key;
	}

}
