package cn.twelvet.multilevel.cache.support;

import com.github.benmanes.caffeine.cache.Cache;

/**
 * 缓存管理
 */
public interface CacheManager extends org.springframework.cache.CacheManager {

	/**
	 * 实现 caffeine 的 {@link Cache} 接口的缓存
	 * @param name 缓存名
	 * @return Cache实现
	 * @param <K> K
	 * @param <V> V
	 */
	<K, V> Cache<K, V> getCaffeineCache(String name);

}
