package cn.twelvet.multilevel.cache.properties;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

/**
 * redis 相关配置
 *
 * @author twelvet
 */
public class RedisConfigProp {

	/**
	 * 全局过期时间，默认不过期
	 */
	private Duration defaultExpiration = Duration.ZERO;

	/**
	 * 全局空值过期时间，默认和有值的过期时间一致，一般设置空值过期时间较短
	 */
	private Duration defaultNullValuesExpiration = null;

	/**
	 * 每个cacheName的过期时间，优先级比defaultExpiration高
	 */
	private Map<String, Duration> expires = new HashMap<>();

	/**
	 * 缓存更新时通知其他节点的topic名称
	 */
	private String topic = "cache:redis:caffeine:topic";

	/**
	 * 生成当前节点id的key，当配置了spring.cache.multi.server-id时，该配置不生效
	 */
	private String serverIdGeneratorKey = "cache:redis:caffeine:server-id-sequence";

	/**
	 * getDefaultExpiration
	 * @return Duration
	 */
	public Duration getDefaultExpiration() {
		return defaultExpiration;
	}

	/**
	 * setDefaultExpiration
	 * @param defaultExpiration Duration
	 */
	public void setDefaultExpiration(Duration defaultExpiration) {
		this.defaultExpiration = defaultExpiration;
	}

	/**
	 * getDefaultNullValuesExpiration
	 * @return Duration
	 */
	public Duration getDefaultNullValuesExpiration() {
		return defaultNullValuesExpiration;
	}

	/**
	 * setDefaultNullValuesExpiration
	 * @param defaultNullValuesExpiration Duration
	 */
	public void setDefaultNullValuesExpiration(Duration defaultNullValuesExpiration) {
		this.defaultNullValuesExpiration = defaultNullValuesExpiration;
	}

	/**
	 * getExpires
	 * @return Map String, Duration
	 */
	public Map<String, Duration> getExpires() {
		return expires;
	}

	/**
	 * setExpires
	 * @param expires Map String, Duration
	 */
	public void setExpires(Map<String, Duration> expires) {
		this.expires = expires;
	}

	/**
	 * getTopic
	 * @return String
	 */
	public String getTopic() {
		return topic;
	}

	/**
	 * setTopic
	 * @param topic String
	 */
	public void setTopic(String topic) {
		this.topic = topic;
	}

	/**
	 * getServerIdGeneratorKey
	 * @return String
	 */
	public String getServerIdGeneratorKey() {
		return serverIdGeneratorKey;
	}

	/**
	 * setServerIdGeneratorKey
	 * @param serverIdGeneratorKey String
	 */
	public void setServerIdGeneratorKey(String serverIdGeneratorKey) {
		this.serverIdGeneratorKey = serverIdGeneratorKey;
	}

}
